/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jsf.references.JsfResourceIdentifierReferenceSet;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfResourceDirectoryReference
extends PsiPolyVariantReferenceBase
implements EmptyResolveMessageProvider,
LocalQuickFixProvider {
    private final JsfResourceIdentifierReferenceSet myReferenceSet;
    private final int myIndex;

    public JsfResourceDirectoryReference(JsfResourceIdentifierReferenceSet set, TextRange range, int index) {
        super(set.getElement(), range, set.isSoft());
        this.myReferenceSet = set;
        this.myIndex = index;
    }

    @Nullable
    private Collection<PsiDirectory> getContext() {
        return this.myIndex == 0 ? this.myReferenceSet.getResourceLibraryDirectories() : this.getParentDirectories();
    }

    private List<PsiDirectory> getParentDirectories() {
        Object[] results = ((JsfResourceDirectoryReference)this.myReferenceSet.getReference(this.myIndex - 1)).multiResolve(false);
        return ContainerUtil.mapNotNull((Object[])results, (Function)new Function<ResolveResult, PsiDirectory>(){

            public PsiDirectory fun(ResolveResult resolveResult) {
                PsiElement element = resolveResult.getElement();
                if (element instanceof PsiDirectory) {
                    return (PsiDirectory)element;
                }
                return null;
            }
        });
    }

    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        java.util.HashSet<String> added = new java.util.HashSet<String>();
        Collection<PsiDirectory> directories = this.getContext();
        for (PsiDirectory directory : directories) {
            for (PsiDirectory subDirectory : directory.getSubdirectories()) {
                if (added.contains(subDirectory.getName())) continue;
                variants.add(subDirectory);
                added.add(subDirectory.getName());
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfResourceDirectoryReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = FacesBundle.message("cannot.resolve.library", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfResourceDirectoryReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        HashSet resolvResultSet = new HashSet();
        Collection<PsiDirectory> parentDirectories = this.getContext();
        if (parentDirectories != null) {
            String name = this.getValue();
            for (PsiDirectory parentDirectory : parentDirectories) {
                if (this.myIndex == 0 && name.length() == 0) {
                    resolvResultSet.add(new PsiElementResolveResult((PsiElement)parentDirectory));
                    continue;
                }
                PsiDirectory psiDirectory = parentDirectory.findSubdirectory(name);
                if (psiDirectory == null) continue;
                resolvResultSet.add(new PsiElementResolveResult((PsiElement)psiDirectory));
            }
        }
        ResolveResult[] resolveResultArray = resolvResultSet.toArray(new ResolveResult[resolvResultSet.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfResourceDirectoryReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    public JsfResourceIdentifierReferenceSet getReferenceSet() {
        return this.myReferenceSet;
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        Collection<PsiDirectory> context = this.getContext();
        for (PsiDirectory psiDirectory : context) {
            if (!psiDirectory.isWritable()) continue;
            return new LocalQuickFix[]{this.createLocalQuickFix(psiDirectory)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private LocalQuickFix createLocalQuickFix(final PsiDirectory parentDirectory) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = FacesBundle.message("create.resource.directory", JsfResourceDirectoryReference.this.getValue());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfResourceDirectoryReference$2", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = FacesBundle.message("jsf.relocatable.resources", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfResourceDirectoryReference$2", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jsf/references/JsfResourceDirectoryReference$2", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jsf/references/JsfResourceDirectoryReference$2", "applyFix"));
                }
                parentDirectory.createSubdirectory(JsfResourceDirectoryReference.this.getValue());
            }
        };
    }
}

