/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references.contracts;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfContractPsiReference
extends PsiReferenceBase<PsiElement> {
    private final Set<PsiDirectory> myDirectories;

    public JsfContractPsiReference(PsiElement element, Set<PsiDirectory> directories) {
        super(element);
        this.myDirectories = directories;
    }

    public JsfContractPsiReference(PsiElement element, Set<PsiDirectory> directories, TextRange range) {
        super(element, range);
        this.myDirectories = directories;
    }

    @Nullable
    public PsiElement resolve() {
        String value = this.getValue();
        for (PsiDirectory directory : this.myDirectories) {
            if (!value.equals(directory.getName())) continue;
            return directory;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = ArrayUtil.toObjectArray(this.myDirectories);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/contracts/JsfContractPsiReference", "getVariants"));
        }
        return objectArray;
    }
}

