/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.google.common.base.CaseFormat;
import com.google.gson.stream.JsonWriter;
import com.jetbrains.firefox.FirefoxRequest$Companion$WhenMappings;
import com.jetbrains.firefox.rdp.Bindings;
import com.jetbrains.firefox.rdp.FramesResult;
import com.jetbrains.firefox.rdp.ListTabsResult;
import com.jetbrains.firefox.rdp.PropertyResult;
import com.jetbrains.firefox.rdp.PrototypeAndPropertiesResult;
import com.jetbrains.firefox.rdp.PrototypeResult;
import com.jetbrains.firefox.rdp.SetBreakpointResult;
import com.jetbrains.firefox.rdp.SourceResult;
import com.jetbrains.firefox.rdp.SourcesResult;
import com.jetbrains.firefox.rdp.TabAttached;
import com.jetbrains.firefox.rdp.ThreadInterrupted;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.jsonProtocol.OutMessage;
import org.jetbrains.jsonProtocol.Request;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u0013*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/firefox/FirefoxRequest;", "RESULT", "Lorg/jetbrains/jsonProtocol/OutMessage;", "Lorg/jetbrains/jsonProtocol/Request;", "actor", "", "method", "Lcom/jetbrains/firefox/FirefoxRequest$Method;", "(Ljava/lang/String;Lcom/jetbrains/firefox/FirefoxRequest$Method;)V", "getActor", "()Ljava/lang/String;", "getMethod", "()Lcom/jetbrains/firefox/FirefoxRequest$Method;", "methodName", "getMethodName", "finalize", "", "id", "", "Companion", "Method", "FirefoxConnector"})
public final class FirefoxRequest<RESULT>
extends OutMessage
implements Request<RESULT> {
    @NotNull
    private final String methodName = "";
    @NotNull
    private final String actor;
    @NotNull
    private final Method method;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    public void finalize(int id) {
        this.writer.endObject();
        this.writer.close();
    }

    @NotNull
    public final String getActor() {
        return this.actor;
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    public FirefoxRequest(@NotNull String actor, @NotNull Method method) {
        Intrinsics.checkParameterIsNotNull((Object)actor, (String)"actor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        this.actor = actor;
        this.method = method;
        this.writeString("to", this.actor);
        this.writeString("type", this.method.getProtocolName());
        this.methodName = "";
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001a\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/firefox/FirefoxRequest$Method;", "", "protocolName", "", "uglyProtocolResponseType", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getProtocolName", "()Ljava/lang/String;", "getUglyProtocolResponseType", "INITIAL", "LIST_TABS", "RESUME", "ATTACH_TO_TAB", "ATTACH_TO_THREAD", "DETACH", "INTERRUPT", "SET_BREAKPOINT", "DELETE", "FRAMES", "CLIENT_EVALUATE", "SOURCES", "SOURCE", "PROTOTYPE_AND_PROPERTIES", "PROPERTY", "PROTOTYPE", "BINDINGS", "THREAD_GRIP", "THREAD_GRIPS", "RELEASE_MANY", "FirefoxConnector"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method INITIAL;
        public static final /* enum */ Method LIST_TABS;
        public static final /* enum */ Method RESUME;
        public static final /* enum */ Method ATTACH_TO_TAB;
        public static final /* enum */ Method ATTACH_TO_THREAD;
        public static final /* enum */ Method DETACH;
        public static final /* enum */ Method INTERRUPT;
        public static final /* enum */ Method SET_BREAKPOINT;
        public static final /* enum */ Method DELETE;
        public static final /* enum */ Method FRAMES;
        public static final /* enum */ Method CLIENT_EVALUATE;
        public static final /* enum */ Method SOURCES;
        public static final /* enum */ Method SOURCE;
        public static final /* enum */ Method PROTOTYPE_AND_PROPERTIES;
        public static final /* enum */ Method PROPERTY;
        public static final /* enum */ Method PROTOTYPE;
        public static final /* enum */ Method BINDINGS;
        public static final /* enum */ Method THREAD_GRIP;
        public static final /* enum */ Method THREAD_GRIPS;
        public static final /* enum */ Method RELEASE_MANY;
        private static final /* synthetic */ Method[] $VALUES;
        @NotNull
        private final String protocolName;
        @NotNull
        private final String uglyProtocolResponseType;

        static {
            Method[] methodArray = new Method[20];
            Method[] methodArray2 = methodArray;
            methodArray[0] = INITIAL = new Method("INITIAL", 0, null, null, 3, null);
            methodArray[1] = LIST_TABS = new Method("LIST_TABS", 1, null, null, 3, null);
            methodArray[2] = RESUME = new Method("RESUME", 2, null, null, 3, null);
            methodArray[3] = ATTACH_TO_TAB = new Method("attach", "tabAttached");
            methodArray[4] = ATTACH_TO_THREAD = new Method("attach", "paused");
            methodArray[5] = DETACH = new Method("DETACH", 5, null, null, 3, null);
            methodArray[6] = INTERRUPT = new Method("INTERRUPT", 6, null, null, 3, null);
            methodArray[7] = SET_BREAKPOINT = new Method("SET_BREAKPOINT", 7, null, null, 3, null);
            methodArray[8] = DELETE = new Method("DELETE", 8, null, null, 3, null);
            methodArray[9] = FRAMES = new Method("FRAMES", 9, null, null, 3, null);
            methodArray[10] = CLIENT_EVALUATE = new Method(null, "resumed");
            methodArray[11] = SOURCES = new Method("SOURCES", 11, null, null, 3, null);
            methodArray[12] = SOURCE = new Method("SOURCE", 12, null, null, 3, null);
            methodArray[13] = PROTOTYPE_AND_PROPERTIES = new Method("PROTOTYPE_AND_PROPERTIES", 13, null, null, 3, null);
            methodArray[14] = PROPERTY = new Method("PROPERTY", 14, null, null, 3, null);
            methodArray[15] = PROTOTYPE = new Method("PROTOTYPE", 15, null, null, 3, null);
            methodArray[16] = BINDINGS = new Method("BINDINGS", 16, null, null, 3, null);
            methodArray[17] = THREAD_GRIP = new Method("THREAD_GRIP", 17, null, null, 3, null);
            methodArray[18] = THREAD_GRIPS = new Method("THREAD_GRIPS", 18, null, null, 3, null);
            methodArray[19] = RELEASE_MANY = new Method("RELEASE_MANY", 19, null, null, 3, null);
            $VALUES = methodArray;
        }

        @NotNull
        public final String getProtocolName() {
            return this.protocolName;
        }

        @NotNull
        public final String getUglyProtocolResponseType() {
            return this.uglyProtocolResponseType;
        }

        protected Method(String protocolName, String uglyProtocolResponseType) {
            String string = protocolName;
            if (string == null) {
                String string2 = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"CaseFormat.UPPER_UNDERSC\u2026Format.LOWER_CAMEL, name)");
            }
            this.protocolName = string;
            this.uglyProtocolResponseType = uglyProtocolResponseType == null ? this.protocolName + (this.protocolName.charAt(this.protocolName.length() - 1) == 'e' ? "d" : "ed") : uglyProtocolResponseType;
        }

        protected /* synthetic */ Method(String string, int n, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string2 = null;
            }
            if ((n2 & 2) != 0) {
                string3 = null;
            }
            this(string2, string3);
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String string) {
            return Enum.valueOf(Method.class, string);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010\u0014\u001a\u00020\u0007J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\t2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\t2\u0006\u0010\u001c\u001a\u00020\u0007J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\t2\u0006\u0010\u001c\u001a\u00020\u0007J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\tH\u0007J\"\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070)J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070,J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/J$\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u00100\u001a\u0002012\u0006\u0010.\u001a\u00020/J,\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00042\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u0019J\u0014\u00107\u001a\b\u0012\u0004\u0012\u0002080\t2\u0006\u0010\u0017\u001a\u00020\u0007\u00a8\u00069"}, d2={"Lcom/jetbrains/firefox/FirefoxRequest$Companion;", "", "()V", "attachToTab", "Lcom/jetbrains/firefox/FirefoxRequest;", "Lcom/jetbrains/firefox/rdp/TabAttached;", "actor", "", "attachToThread", "Lorg/jetbrains/jsonProtocol/Request;", "Lcom/jetbrains/firefox/rdp/ThreadInterrupted;", "deleteBreakpoint", "Ljava/lang/Void;", "detach", "evaluate", "threadActor", "expression", "frame", "getBindings", "Lcom/jetbrains/firefox/rdp/Bindings;", "environmentActor", "getFrames", "Lcom/jetbrains/firefox/rdp/FramesResult;", "thread", "start", "", "getProperty", "Lcom/jetbrains/firefox/rdp/PropertyResult;", "gripActor", "name", "getPrototype", "Lcom/jetbrains/firefox/rdp/PrototypeResult;", "getPrototypeAndProperties", "Lcom/jetbrains/firefox/rdp/PrototypeAndPropertiesResult;", "getScriptSource", "Lcom/jetbrains/firefox/rdp/SourceResult;", "interrupt", "listTabs", "Lcom/jetbrains/firefox/rdp/ListTabsResult;", "pauseLifetimeGripsToThreadLifetime", "objectActors", "", "pauseToThreadGrip", "release", "", "resumeThread", "pauseOnExceptions", "", "stepAction", "Lorg/jetbrains/debugger/StepAction;", "setBreakpoint", "Lcom/jetbrains/firefox/rdp/SetBreakpointResult;", "url", "line", "column", "sources", "Lcom/jetbrains/firefox/rdp/SourcesResult;", "FirefoxConnector"})
    public static final class Companion {
        @NotNull
        public final Request<PrototypeAndPropertiesResult> getPrototypeAndProperties(@NotNull String gripActor) {
            Intrinsics.checkParameterIsNotNull((Object)gripActor, (String)"gripActor");
            return new FirefoxRequest(gripActor, Method.PROTOTYPE_AND_PROPERTIES);
        }

        @NotNull
        public final Request<PropertyResult> getProperty(@NotNull String gripActor, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)gripActor, (String)"gripActor");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            FirefoxRequest request = new FirefoxRequest(gripActor, Method.PROPERTY);
            request.writeString("name", name);
            return request;
        }

        @NotNull
        public final Request<PrototypeResult> getPrototype(@NotNull String gripActor) {
            Intrinsics.checkParameterIsNotNull((Object)gripActor, (String)"gripActor");
            return new FirefoxRequest(gripActor, Method.PROTOTYPE);
        }

        @NotNull
        public final Request<Bindings> getBindings(@NotNull String environmentActor) {
            Intrinsics.checkParameterIsNotNull((Object)environmentActor, (String)"environmentActor");
            return new FirefoxRequest(environmentActor, Method.BINDINGS);
        }

        @NotNull
        public final FirefoxRequest<Void> pauseToThreadGrip(@NotNull String actor) {
            Intrinsics.checkParameterIsNotNull((Object)actor, (String)"actor");
            return new FirefoxRequest<Void>(actor, Method.THREAD_GRIP);
        }

        @NotNull
        public final Request<Void> pauseLifetimeGripsToThreadLifetime(@NotNull String threadActor, @NotNull List<String> objectActors) {
            Intrinsics.checkParameterIsNotNull((Object)threadActor, (String)"threadActor");
            Intrinsics.checkParameterIsNotNull(objectActors, (String)"objectActors");
            FirefoxRequest request = new FirefoxRequest(threadActor, Method.THREAD_GRIPS);
            request.writeStringList("actors", objectActors);
            return request;
        }

        @NotNull
        public final FirefoxRequest<Void> release(@NotNull String threadActor, @NotNull Collection<String> objectActors) {
            Intrinsics.checkParameterIsNotNull((Object)threadActor, (String)"threadActor");
            Intrinsics.checkParameterIsNotNull(objectActors, (String)"objectActors");
            FirefoxRequest<Void> request = new FirefoxRequest<Void>(threadActor, Method.RELEASE_MANY);
            request.writeStringList("actors", objectActors);
            return request;
        }

        @NotNull
        public final Request<SourceResult> getScriptSource(@NotNull String actor) {
            Intrinsics.checkParameterIsNotNull((Object)actor, (String)"actor");
            return new FirefoxRequest(actor, Method.SOURCE);
        }

        @JvmOverloads
        @NotNull
        public final Request<FramesResult> getFrames(@NotNull String thread, int start) {
            Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
            FirefoxRequest request = new FirefoxRequest(thread, Method.FRAMES);
            if (start != 0) {
                request.writeInt("start", start);
            }
            return request;
        }

        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ Request getFrames$default(Companion companion, String string, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFrames");
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.getFrames(string, n);
        }

        @JvmOverloads
        @NotNull
        public Request<FramesResult> getFrames(@NotNull String string) {
            return com.jetbrains.firefox.FirefoxRequest$Companion.getFrames$default(this, string, 0, 2, null);
        }

        @NotNull
        public final Request<ListTabsResult> listTabs() {
            return new FirefoxRequest("root", Method.LIST_TABS);
        }

        @NotNull
        public final FirefoxRequest<TabAttached> attachToTab(@NotNull String actor) {
            Intrinsics.checkParameterIsNotNull((Object)actor, (String)"actor");
            return new FirefoxRequest<TabAttached>(actor, Method.ATTACH_TO_TAB);
        }

        @NotNull
        public final FirefoxRequest<Void> detach(@NotNull String actor) {
            Intrinsics.checkParameterIsNotNull((Object)actor, (String)"actor");
            return new FirefoxRequest<Void>(actor, Method.DETACH);
        }

        @NotNull
        public final Request<ThreadInterrupted> attachToThread(@NotNull String actor) {
            Intrinsics.checkParameterIsNotNull((Object)actor, (String)"actor");
            return new FirefoxRequest(actor, Method.ATTACH_TO_THREAD);
        }

        @NotNull
        public final Request<Void> resumeThread(@NotNull String thread, boolean pauseOnExceptions) {
            Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
            return this.resumeThread(thread, StepAction.CONTINUE, pauseOnExceptions);
        }

        @NotNull
        public final Request<Void> resumeThread(@NotNull String thread, @NotNull StepAction stepAction, boolean pauseOnExceptions) {
            Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
            Intrinsics.checkParameterIsNotNull((Object)stepAction, (String)"stepAction");
            FirefoxRequest request = new FirefoxRequest(thread, Method.RESUME);
            try {
                JsonWriter writer = request.writer;
                if (pauseOnExceptions) {
                    writer.name("pauseOnExceptions").value(true);
                }
                if (stepAction != StepAction.CONTINUE) {
                    String stupidRawStepType;
                    writer.name("resumeLimit").beginObject().name("type");
                    switch (FirefoxRequest$Companion$WhenMappings.$EnumSwitchMapping$0[stepAction.ordinal()]) {
                        case 1: {
                            stupidRawStepType = "step";
                            break;
                        }
                        case 2: {
                            stupidRawStepType = "next";
                            break;
                        }
                        case 3: {
                            stupidRawStepType = "finish";
                            break;
                        }
                        default: {
                            throw (Throwable)new UnsupportedOperationException();
                        }
                    }
                    writer.value(stupidRawStepType).endObject();
                }
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException(e);
            }
            return request;
        }

        @NotNull
        public final Request<ThreadInterrupted> interrupt(@NotNull String thread) {
            Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
            return new FirefoxRequest(thread, Method.INTERRUPT);
        }

        @NotNull
        public final Request<SourcesResult> sources(@NotNull String thread) {
            Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
            return new FirefoxRequest(thread, Method.SOURCES);
        }

        @NotNull
        public final FirefoxRequest<SetBreakpointResult> setBreakpoint(@NotNull String thread, @NotNull String url, int line, int column) {
            Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            FirefoxRequest<SetBreakpointResult> request = new FirefoxRequest<SetBreakpointResult>(thread, Method.SET_BREAKPOINT);
            try {
                JsonWriter writer = request.writer;
                writer.name("location");
                writer.beginObject();
                writer.name("url").value(url);
                writer.name("line").value((long)(line + 1));
                if (column != -1) {
                    writer.name("column").value((long)(column + 1));
                }
                writer.endObject();
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException(e);
            }
            return request;
        }

        @NotNull
        public final FirefoxRequest<Void> deleteBreakpoint(@NotNull String actor) {
            Intrinsics.checkParameterIsNotNull((Object)actor, (String)"actor");
            return new FirefoxRequest<Void>(actor, Method.DELETE);
        }

        @NotNull
        public final FirefoxRequest<Void> evaluate(@NotNull String threadActor, @NotNull String expression, @NotNull String frame) {
            Intrinsics.checkParameterIsNotNull((Object)threadActor, (String)"threadActor");
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            FirefoxRequest<Void> request = new FirefoxRequest<Void>(threadActor, Method.CLIENT_EVALUATE);
            try {
                JsonWriter writer = request.writer;
                writer.name("expression").value(expression);
                writer.name("frame").value(frame);
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException(e);
            }
            return request;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

