/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.data.util.SpringDataUtil;
import com.intellij.spring.data.util.nodes.QueryNode;
import com.intellij.spring.data.util.nodes.RootNode;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class QueryTree {
    private String myMethodName;
    private RootNode myRoot;

    public QueryTree(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/data/util/QueryTree", "<init>"));
        }
        this.myMethodName = methodName;
        String expression = this.strip(this.myMethodName);
        this.myRoot = new RootNode(expression, StringUtil.isEmptyOrSpaces((String)expression) ? this.myMethodName : this.myMethodName.substring(0, this.myMethodName.indexOf(expression)));
    }

    @NotNull
    private String strip(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/data/util/QueryTree", "strip"));
        }
        Matcher matcher = SpringDataUtil.METHOD_TEMPLATE.matcher(methodName);
        if (matcher.find()) {
            String string = methodName.substring(matcher.group().length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/util/QueryTree", "strip"));
            }
            return string;
        }
        String string = methodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/util/QueryTree", "strip"));
        }
        return string;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public RootNode getRoot() {
        return this.myRoot;
    }

    public QueryNode[] toLeavesArray() {
        LinkedHashSet<QueryNode> nodes = new LinkedHashSet<QueryNode>();
        QueryTree.collectLeaves(this.getRoot(), nodes);
        return nodes.toArray(new QueryNode[nodes.size()]);
    }

    private static void collectLeaves(@NotNull QueryNode node, @NotNull Set<QueryNode> nodes) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/data/util/QueryTree", "collectLeaves"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/spring/data/util/QueryTree", "collectLeaves"));
        }
        Set<? extends QueryNode> children = node.getChildren();
        if (children.size() == 0) {
            nodes.add(node);
        } else {
            for (QueryNode queryNode : children) {
                QueryTree.collectLeaves(queryNode, nodes);
            }
        }
    }
}

