/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib.vectordrawable;

class PathBuilder {
    private StringBuilder mPathData = new StringBuilder();

    PathBuilder() {
    }

    private String booleanToString(boolean flag) {
        return flag ? "1" : "0";
    }

    public PathBuilder absoluteMoveTo(float x, float y) {
        this.mPathData.append("M" + x + "," + y);
        return this;
    }

    public PathBuilder relativeMoveTo(float x, float y) {
        this.mPathData.append("m" + x + "," + y);
        return this;
    }

    public PathBuilder absoluteLineTo(float x, float y) {
        this.mPathData.append("L" + x + "," + y);
        return this;
    }

    public PathBuilder relativeLineTo(float x, float y) {
        this.mPathData.append("l" + x + "," + y);
        return this;
    }

    public PathBuilder absoluteVerticalTo(float v) {
        this.mPathData.append("V" + v);
        return this;
    }

    public PathBuilder relativeVerticalTo(float v) {
        this.mPathData.append("v" + v);
        return this;
    }

    public PathBuilder absoluteHorizontalTo(float h) {
        this.mPathData.append("H" + h);
        return this;
    }

    public PathBuilder relativeHorizontalTo(float h) {
        this.mPathData.append("h" + h);
        return this;
    }

    public PathBuilder absoluteArcTo(float rx, float ry, boolean rotation, boolean largeArc, boolean sweep, float x, float y) {
        this.mPathData.append("A" + rx + "," + ry + "," + this.booleanToString(rotation) + "," + this.booleanToString(largeArc) + "," + this.booleanToString(sweep) + "," + x + "," + y);
        return this;
    }

    public PathBuilder relativeArcTo(float rx, float ry, boolean rotation, boolean largeArc, boolean sweep, float x, float y) {
        this.mPathData.append("a" + rx + "," + ry + "," + this.booleanToString(rotation) + "," + this.booleanToString(largeArc) + "," + this.booleanToString(sweep) + "," + x + "," + y);
        return this;
    }

    public PathBuilder absoluteClose() {
        this.mPathData.append("Z");
        return this;
    }

    public PathBuilder relativeClose() {
        this.mPathData.append("z");
        return this;
    }

    public String toString() {
        return this.mPathData.toString();
    }
}

