/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class SQLiteDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(SQLiteDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("SQLiteString", "Using STRING instead of TEXT", "In SQLite, any column can store any data type; the declared type for a column is more of a hint as to what the data should be cast to when stored.\n\nThere are many ways to store a string. `TEXT`, `VARCHAR`, `CHARACTER` and `CLOB` are string types, *but `STRING` is not*. Columns defined as STRING are actually numeric.\n\nIf you try to store a value in a numeric column, SQLite will try to cast it to a float or an integer before storing. If it can't, it will just store it as a string.\n\nThis can lead to some subtle bugs. For example, when SQLite encounters a string like `1234567e1234`, it will parse it as a float, but the result will be out of range for floating point numbers, so `Inf` will be stored! Similarly, strings that look like integers will lose leading zeroes.\n\nTo fix this, you can change your schema to use a `TEXT` type instead.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://www.sqlite.org/datatype3.html");

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("execSQL");
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        Iterator iterator;
        Node argument;
        String sql;
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        if (!method.getContainingClass().matches("android.database.sqlite.SQLiteDatabase")) {
            return;
        }
        if (method.getArgumentCount() > 0 && method.getArgumentType(0).matchesSignature("java.lang.String") && node.astArguments().size() == method.getArgumentCount() && (sql = ConstantEvaluator.evaluateString(context, argument = (Node)(iterator = node.astArguments().iterator()).next(), true)) != null && (sql.startsWith("CREATE TABLE") || sql.startsWith("ALTER TABLE")) && sql.matches(".*\\bSTRING\\b.*")) {
            String message = "Using column type STRING; did you mean to use TEXT? (STRING is a numeric type and its value can be adjusted; for example,strings that look like integers can drop leading zeroes. See issue explanation for details.)";
            context.report(ISSUE, (Node)node, context.getLocation((Node)node), message);
        }
    }
}

