/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.perflib.heap.StackFrame;

public class StackTrace {
    int mSerialNumber;
    int mThreadSerialNumber;
    StackFrame[] mFrames;
    @Nullable
    StackTrace mParent = null;
    int mOffset = 0;

    private StackTrace() {
    }

    public StackTrace(int serial, int thread, StackFrame[] frames) {
        this.mSerialNumber = serial;
        this.mThreadSerialNumber = thread;
        this.mFrames = frames;
    }

    @NonNull
    public final StackTrace fromDepth(int startingDepth) {
        StackTrace result = new StackTrace();
        result.mParent = this.mParent != null ? this.mParent : this;
        result.mOffset = startingDepth + this.mOffset;
        return result;
    }

    public final void dump() {
        int N = this.mFrames.length;
        for (int i = 0; i < N; ++i) {
            System.out.println(this.mFrames[i].toString());
        }
    }
}

