/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.core.actions.ShowDiagramBase;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class ShowDiagram
extends ShowDiagramBase {
    @Override
    protected boolean isPopup() {
        return false;
    }

    @Override
    @Nullable
    protected Runnable show(final Object element, final DiagramProvider provider, final Project project, RelativePoint point, final Collection additionalElements) {
        String url = "uml://" + provider.getID() + "/" + provider.getVfsResolver().getQualifiedName(element);
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (virtualFile instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            final UmlVirtualFileSystem.UmlVirtualFile file = (UmlVirtualFileSystem.UmlVirtualFile)virtualFile;
            file.setState(null);
            String text = provider.getElementManager().getEditorTitle(element, new DiagramState(), additionalElements);
            if (text != null) {
                file.setPresentableName(text);
            }
            if (file.getProject() == null) {
                file.setProject(project);
            }
            return new Runnable(){

                @Override
                public void run() {
                    DiagramDataModel dataModel;
                    file.putUserData(DiagramProvider.ORIGINAL_ELEMENT, element);
                    final UmlGraphBuilder builder = UmlGraphBuilderFactory.create(project, provider, element, file);
                    if (builder != null && (dataModel = builder.getDataModel()) != null) {
                        for (Object additionalElement : additionalElements) {
                            dataModel.addElement(additionalElement);
                        }
                        dataModel.refreshDataModel();
                        dataModel.setModelInitializationFinished();
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UmlVirtualFileSystem.setInitialized(file);
                                FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, true);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        builder.update(false, true);
                                        if (DiagramConfiguration.getConfiguration().fitContentAfterLayout) {
                                            builder.getView().fitContent();
                                            builder.getGraph().updateViews();
                                        } else {
                                            builder.getView().fitContent();
                                            builder.getGraph().updateViews();
                                        }
                                        for (Object o : builder.getDataModel().getNodes()) {
                                            DiagramNode node = (DiagramNode)o;
                                            if (!node.getIdentifyingElement().equals(element)) continue;
                                            builder.setSelected(node, true);
                                            break;
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
            };
        }
        return null;
    }
}

