/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShowDiagramBase
extends AnAction {
    private boolean myIsCalledFromList = false;

    protected ShowDiagramBase() {
        this.setInjectedContext(true);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (CommonDataKeys.PROJECT.getData(e.getDataContext()) == null) {
            presentation.setEnabled(false);
            return;
        }
        DiagramProvider umlProvider = this.getProvider(e);
        if (umlProvider == null) {
            umlProvider = DiagramProvider.findProvider((DataContext)e.getDataContext());
        }
        boolean enabled = umlProvider != null;
        String place = e.getPlace();
        if (!DiagramProvider.hasPlace((String)place)) {
            presentation.setVisible(enabled);
        }
        presentation.setEnabled(enabled);
        if (enabled) {
            presentation.setIcon(umlProvider.getActionIcon(this.isPopup()));
            presentation.setText("Show " + umlProvider.getActionName(this.isPopup()) + (this.isPopup() ? " Popup" : "") + "...");
        }
    }

    protected abstract boolean isPopup();

    @Nullable
    public DiagramProvider getProvider(AnActionEvent e) {
        return null;
    }

    public String getFeatureId() {
        return "diagram.show";
    }

    public final boolean isCalledFromJList() {
        return this.myIsCalledFromList;
    }

    public void actionPerformed(AnActionEvent e) {
        RelativePoint location;
        Object[] objectArray;
        DataContext context = e.getDataContext();
        DiagramProvider umlProvider = this.getProvider(e);
        if (umlProvider == null) {
            objectArray = DiagramProvider.findProviders((DataContext)context, (String)e.getPlace());
        } else {
            Object[] objectArray2 = new DiagramProvider[1];
            objectArray = objectArray2;
            objectArray2[0] = umlProvider;
        }
        Object[] providers = objectArray;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureId());
        if (providers.length == 0 || project == null) {
            return;
        }
        Component comp = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        AbstractPopup.MyContentPanel panel = comp == null ? null : (AbstractPopup.MyContentPanel)UIUtil.getParentOfType(AbstractPopup.MyContentPanel.class, (Component)comp);
        this.myIsCalledFromList = panel != null;
        RelativePoint point = location = this.getLocation(context, e);
        if (providers.length > 1) {
            Object[] elem = new Object[providers.length];
            Object[] elems = new Object[providers.length];
            String[] names = new String[providers.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = providers[i].getPresentableName();
                elem[i] = this.findInDataContext((DiagramProvider)providers[i], context);
                elems[i] = providers[i].getElementManager().findElementsInDataContext(context);
            }
            final JBList jList = new JBList(providers);
            jList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof DiagramProvider) {
                        DiagramProvider provider = (DiagramProvider)value;
                        this.setText(provider.getPresentableName());
                        this.setIcon(provider.getActionIcon(ShowDiagramBase.this.isPopup()));
                    }
                    return rendererComponent;
                }
            });
            PopupChooserBuilder popupBuilder = JBPopupFactory.getInstance().createListPopupBuilder((JList)jList);
            JBPopup popup = popupBuilder.setTitle(UmlBundle.message("select.uml.provider", new Object[0])).setResizable(false).setMovable(false).setItemChoosenCallback(new Runnable((DiagramProvider[])providers, project, elem, elems, point){
                final /* synthetic */ DiagramProvider[] val$providers;
                final /* synthetic */ Project val$project;
                final /* synthetic */ Object[] val$elem;
                final /* synthetic */ Object[] val$elems;
                final /* synthetic */ RelativePoint val$point;
                {
                    this.val$providers = diagramProviderArray;
                    this.val$project = project;
                    this.val$elem = objectArray;
                    this.val$elems = objectArray2;
                    this.val$point = relativePoint;
                }

                @Override
                public void run() {
                    int index = jList.getSelectedIndex();
                    if (0 <= index && index < this.val$providers.length) {
                        ShowDiagramBase.this.showUnderProgress(this.val$providers[index], this.val$project, this.val$elem[index], (Collection)this.val$elems[index], this.val$point);
                    }
                }
            }).createPopup();
            popup.showInBestPositionFor(context);
        } else {
            ArrayList elements = providers[0].getElementManager().findElementsInDataContext(context);
            if (elements.size() > 0) {
                elements = new ArrayList(elements);
            }
            this.showUnderProgress(providers[0], project, this.findInDataContext(providers[0], context), elements, point);
        }
    }

    protected Object findInDataContext(DiagramProvider provider, DataContext context) {
        return provider.getElementManager().findInDataContext(context);
    }

    @NotNull
    protected RelativePoint getLocation(DataContext context, AnActionEvent e) {
        RelativePoint relativePoint = PopupFactoryImpl.getInstance().guessBestPopupLocation(context);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/core/actions/ShowDiagramBase", "getLocation"));
        }
        return relativePoint;
    }

    @Nullable
    protected abstract Runnable show(Object var1, DiagramProvider var2, Project var3, RelativePoint var4, Collection var5);

    protected void showUnderProgress(final DiagramProvider provider, final Project project, @Nullable Object element, final Collection elements, final RelativePoint point) {
        UsageTrigger.trigger((String)("uml.ShowDiagram." + provider.getID() + (this.isPopup() ? ".popup" : "")));
        final Ref postbackAction = Ref.create(null);
        final Object obj = element != null ? element : (!elements.isEmpty() ? elements.iterator().next() : null);
        elements.remove(obj);
        Runnable process = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                        Runnable callback = ShowDiagramBase.this.show(obj, provider, project, point, elements);
                        if (ShowDiagramBase.this.isPopup()) {
                            postbackAction.set((Object)callback);
                        } else {
                            callback.run();
                        }
                    }
                });
            }
        };
        if (this.isUnderProgress() && !this.isCalledFromJList()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process, UmlBundle.message("building.diagram", provider.getPresentableName()), true, project);
        } else {
            postbackAction.set((Object)this.show(obj, provider, project, point, elements));
        }
        if (!postbackAction.isNull()) {
            ((Runnable)postbackAction.get()).run();
        }
    }

    public void showDiagramUnderProgress(DiagramProvider provider, Project project, @Nullable Object element) {
        this.showUnderProgress(provider, project, element, Collections.emptyList(), null);
    }

    protected boolean isUnderProgress() {
        return true;
    }
}

