/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.components.JBList;
import com.intellij.uml.project.ModuleItem;
import com.intellij.uml.project.ModulesUmlNode;
import com.intellij.uml.project.actions.ModuleNodeIntentionActionBase;
import com.intellij.uml.project.ui.ModulesListCellRenderer;
import com.intellij.util.Function;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ShowPathsToModuleAction
extends ModuleNodeIntentionActionBase {
    public ShowPathsToModuleAction() {
        super("Show paths to a module", null, null);
    }

    public void perform(DiagramNode<ModuleItem> n, final DiagramBuilder builder) {
        final ModulesUmlNode node = (ModulesUmlNode)n;
        final Project project = builder.getProject();
        Module module = ((ModuleItem)n.getIdentifyingElement()).getModule();
        ArrayList<Module> modules = new ArrayList<Module>(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
        modules.remove(module);
        final JBList list = new JBList(modules);
        list.setCellRenderer((ListCellRenderer)new ModulesListCellRenderer());
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                Task.Backgroundable task = new Task.Backgroundable(builder.getProject(), "Calculating Paths Between Modules", true){
                    private ProgressIndicator myIndicator;

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/uml/project/actions/ShowPathsToModuleAction$1$1", "run"));
                        }
                        this.myIndicator = indicator;
                        Module m = (Module)list.getSelectedValue();
                        if (m != null) {
                            this.showPathFor(node, new ModuleItem(m), builder);
                        }
                    }

                    private void showPathFor(ModulesUmlNode node, ModuleItem item, DiagramBuilder builder) {
                        if (item.isModule()) {
                            Module moduleFrom = node.getIdentifyingElement().getModule();
                            Module moduleTo = item.getModule();
                            Graph<Module> moduleGraph = ModuleNodeIntentionActionBase.buildModulesGraph(builder, project);
                            GraphAlgorithms graphAlgorithms = GraphAlgorithms.getInstance();
                            List shortestPaths = graphAlgorithms.findKShortestPaths(moduleGraph, (Object)moduleFrom, (Object)moduleTo, 5, this.myIndicator);
                            List paths = graphAlgorithms.removePathsWithCycles(shortestPaths);
                            if (this.myIndicator.isCanceled()) {
                                return;
                            }
                            if (paths.isEmpty()) {
                                DiagramAction.showNotification((String)("No paths to module " + moduleTo.getName() + " have been found"), (DiagramNode)node, (DiagramBuilder)builder);
                            } else {
                                ShowPathsToModuleAction.this.showPaths(builder, paths);
                            }
                        }
                    }
                };
                ProgressManager.getInstance().run((Task)task);
            }
        };
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select Target Module                         ").setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return ((Module)o).getName();
            }
        }).setAutoselectOnMouseMove(true).setItemChoosenCallback(callback).createPopup();
        Utils.showPopupBeneathNode((JBPopup)popup, (Node)builder.getNode((DiagramNode)node), (Graph2DView)builder.getView());
    }
}

