/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.utils;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.uml.utils.UmlBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlJavaUtils {
    @Nullable
    public static String getPackageName(final PsiElement element) {
        if (element instanceof PsiClass) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return ((PsiClassOwner)element.getContainingFile()).getPackageName();
                }
            });
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static String getRealPackageName(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            PsiClass aClass = (PsiClass)psiElement;
            while (aClass.getContainingClass() != null) {
                PsiClass c = aClass.getContainingClass();
                if (c == null) {
                    return UmlJavaUtils.getPackageName((PsiElement)c);
                }
                aClass = c;
            }
            return UmlJavaUtils.getPackageName((PsiElement)aClass);
        }
        return UmlJavaUtils.getPackageName(psiElement);
    }

    @Nullable
    public static PsiPackage getPackage(PsiElement element) {
        String fqn = UmlJavaUtils.getRealPackageName(element);
        return fqn == null ? null : JavaPsiFacade.getInstance((Project)element.getProject()).findPackage(fqn);
    }

    public static PackageInfo getInfo(PsiPackage p) {
        return new PackageInfo(p);
    }

    public static boolean prepareClassForWrite(PsiClass psiClass) {
        boolean prepared = CodeInsightUtil.preparePsiElementsForWrite((PsiElement[])new PsiElement[]{psiClass});
        if (!prepared) {
            Messages.showErrorDialog((Project)psiClass.getProject(), (String)UmlBundle.message("class.is.readonly", psiClass.getName()), (String)UmlBundle.message("error", new Object[0]));
        }
        return prepared;
    }

    @Nullable
    public static String getFQN(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uml/utils/UmlJavaUtils", "getFQN"));
        }
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        return null;
    }

    public static class PackageInfo {
        private int totalClassesCount = 0;
        private int totalSubpackagesCount = 0;
        private int classesCount = 0;
        private int subpackagesCount = 0;
        private final String fqn;

        private PackageInfo(PsiPackage p) {
            this.fqn = p.getQualifiedName();
            this.classesCount = p.getClasses().length;
            this.subpackagesCount = p.getSubPackages().length;
            this.traverse(p);
        }

        private void traverse(PsiPackage p) {
            this.totalClassesCount += p.getClasses().length;
            this.totalSubpackagesCount += p.getSubPackages().length;
            for (PsiPackage aPackage : p.getSubPackages()) {
                this.traverse(aPackage);
            }
        }

        @NonNls
        public String toString() {
            return "<html><body>Package <font color=green>" + this.fqn + "</font><br>" + "Contains:<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;<font color=blue>" + this.classesCount + "</font>" + (this.classesCount == 1 ? " class" : " classes") + "<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;<font color=blue>" + this.subpackagesCount + "</font>" + (this.subpackagesCount == 1 ? " subpackage" : " subpackages") + "<br>" + "Total:<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;<font color=blue>" + this.totalClassesCount + "</font>" + (this.totalClassesCount == 1 ? " class" : " classes") + "<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;<font color=blue>" + this.totalSubpackagesCount + "</font>" + (this.totalSubpackagesCount == 1 ? " subpackage" : " subpackages") + "</body></html>";
        }
    }
}

