/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.utils;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class UmlPsiUtil {
    private static final String ID = "UML";

    private UmlPsiUtil() {
    }

    public static void runWriteActionInCommandProcessor(final Project project, final DocumentReference ref, String name, final Runnable run) {
        Runnable cmd = new Runnable(){

            @Override
            public void run() {
                if (ref != null) {
                    UndoManager.getInstance((Project)project).nonundoableActionPerformed(ref, true);
                }
                ApplicationManager.getApplication().runWriteAction(run);
            }
        };
        CommandProcessor.getInstance().executeCommand(project, cmd, name, (Object)ID, UndoConfirmationPolicy.DEFAULT, null);
    }

    public static void runWriteActionInCommandProcessor(Project project, PsiElement element, Runnable run) {
        UmlPsiUtil.runWriteActionInCommandProcessor(project, element, "Unknown UML action", run);
    }

    public static void runWriteActionInCommandProcessor(Project project, PsiElement element, String name, Runnable run) {
        VirtualFile file;
        PsiFile psiFile = element.getContainingFile();
        DocumentReference ref = psiFile == null || (file = psiFile.getVirtualFile()) == null ? null : DocumentReferenceManager.getInstance().create(file);
        UmlPsiUtil.runWriteActionInCommandProcessor(project, ref, "Unknown UML action", run);
    }

    @Nullable
    public static String createInheritanceBetween(PsiClass child, PsiClass parent) throws IncorrectOperationException {
        if (child.isInheritor(parent, true) || parent.isInheritor(child, true)) {
            return UmlBundle.message("relationship.already.exists", child.getName(), parent.getName());
        }
        if (child.equals(parent)) {
            return null;
        }
        PsiModifierList modifiers = parent.getModifierList();
        if (modifiers == null) {
            return null;
        }
        if (child.isAnnotationType() && !parent.isAnnotationType()) {
            return UmlBundle.message("annotation.class.cant.be.extended.or.implemented", new Object[0]);
        }
        if (modifiers.hasModifierProperty("final")) {
            return UmlBundle.message("final.class.cant.be.inherited", parent.getName());
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)child.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        if (parent.isInterface()) {
            PsiReferenceList implementsList;
            PsiJavaCodeReferenceElement ref = factory.createClassReferenceElement(parent);
            PsiReferenceList psiReferenceList = implementsList = child.isInterface() ? child.getExtendsList() : child.getImplementsList();
            if (implementsList != null) {
                implementsList.add((PsiElement)ref);
            }
        } else {
            if (child.isInterface()) {
                return UmlBundle.message("node.is.interface", new Object[0]);
            }
            PsiClass superClass = child.getSuperClass();
            if (superClass != null) {
                PsiJavaCodeReferenceElement ref = factory.createClassReferenceElement(parent);
                PsiReferenceList extendsList = child.getExtendsList();
                if (extendsList != null) {
                    if (extendsList.getReferenceElements().length > 0) {
                        extendsList.getReferenceElements()[0].replace((PsiElement)ref);
                    } else {
                        extendsList.add((PsiElement)ref);
                    }
                }
            } else if (facade.findClass("java.lang.Object", GlobalSearchScope.allScope((Project)child.getProject())) == null) {
                return UmlBundle.message("set.up.jdk", new Object[0]);
            }
        }
        return null;
    }

    public static void makeClassAbstract(final PsiClass child) {
        UmlPsiUtil.runWriteActionInCommandProcessor(child.getProject(), (PsiElement)child, UmlBundle.message("make.class.abstract", new Object[0]), new Runnable(){

            @Override
            public void run() {
                try {
                    PsiModifierList modifierList = child.getModifierList();
                    if (modifierList != null) {
                        modifierList.setModifierProperty("abstract", true);
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
        });
    }

    public static boolean isAbstract(PsiClass child) {
        PsiModifierList modifierList = child.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("abstract");
    }

    @Nullable
    public static String annotateClass(PsiClass psiClass, PsiClass anno) {
        if (psiClass == null || anno == null) {
            return null;
        }
        assert (anno.isAnnotationType());
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return null;
        }
        String fqn = anno.getQualifiedName();
        if (fqn == null || modifierList.findAnnotation(fqn) != null) {
            return null;
        }
        return UmlPsiUtil.addAnnotation(psiClass, fqn) ? null : "Can't annotate class " + psiClass.getQualifiedName();
    }

    @Nullable
    public static PsiClass findAnnotationClass(PsiAnnotation annotation) {
        PsiElement psiClass;
        if (annotation == null) {
            return null;
        }
        PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
        if (ref == null) {
            return null;
        }
        PsiElement refElement = ref.getElement();
        if (refElement instanceof PsiJavaCodeReferenceElement && (psiClass = ((PsiJavaCodeReferenceElement)refElement).resolve()) instanceof PsiClass) {
            return (PsiClass)psiClass;
        }
        return null;
    }

    public static Set<PsiClass> findAnnotationsForClass(PsiClass psiClass) {
        HashSet classes = new HashSet();
        if (psiClass == null) {
            return classes;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return classes;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            PsiClass aClass = UmlPsiUtil.findAnnotationClass(annotation);
            if (aClass == null) continue;
            classes.add(aClass);
        }
        return classes;
    }

    public static boolean addAnnotation(final PsiClass psiElement, final String fqn) {
        final boolean[] result = new boolean[]{false};
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiModifierList modifierList = psiElement.getModifierList();
                    if (modifierList == null) {
                        return;
                    }
                    if (!FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
                        return;
                    }
                    Project project = psiElement.getProject();
                    PsiAnnotation psiAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@" + fqn, (PsiElement)psiElement);
                    PsiElement element = modifierList.getFirstChild();
                    if (element != null) {
                        modifierList.addBefore((PsiElement)psiAnnotation, element);
                    } else {
                        modifierList.add((PsiElement)psiAnnotation);
                    }
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
                    result[0] = true;
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
        });
        return result[0];
    }

    public static Collection<PsiClass> getAllInnerClasses(PsiClass psiClass) {
        HashSet inners = new HashSet();
        for (PsiClass inner : psiClass.getInnerClasses()) {
            if (inner.getName() == null) continue;
            inners.add(inner);
            inners.addAll(UmlPsiUtil.getAllInnerClasses(inner));
        }
        return inners;
    }
}

