/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import icons.CdiCoreIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiInjectionsClassAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        PsiElement parent;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator", "annotate"));
        }
        if (psiElement instanceof PsiIdentifier && (parent = psiElement.getParent()) instanceof PsiClass) {
            PsiFile containingFile = parent.getContainingFile();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)parent);
            if (module != null && CdiCommonUtils.isCdiInstalled(module)) {
                PsiClass psiClass = (PsiClass)parent;
                if (CdiCommonUtils.isClassContainsCdiAnnotations(psiClass, module)) {
                    Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(psiClass);
                    for (InjectionPointDescriptor ip : injectionPoints) {
                        PsiModifierListOwner owner = ip.getOwner();
                        if (!containingFile.equals(owner.getContainingFile())) continue;
                        CdiInjectionsClassAnnotator.addInjectedGutterIcon(holder, CdiInjectionUtils.getInjectedBeans(ip), owner, ip.getType());
                    }
                }
                if (CdiInjectionUtils.canBeInjected(psiClass, module)) {
                    PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createType(psiClass);
                    CdiInjectionsClassAnnotator.addOutjectedGutter(holder, module, (PsiMember)psiClass, (PsiType)psiClassType);
                    for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods((PsiClass)parent, false)) {
                        CdiInjectionsClassAnnotator.addOutjectedGutter(holder, module, (PsiMember)psiMethod, psiMethod.getReturnType());
                    }
                    for (PsiField psiField : CdiCommonUtils.getProducerFields((PsiClass)parent, false)) {
                        CdiInjectionsClassAnnotator.addOutjectedGutter(holder, module, (PsiMember)psiField, psiField.getType());
                    }
                }
            }
        }
    }

    private static void addOutjectedGutter(@NotNull AnnotationHolder holder, @NotNull Module module, @Nullable PsiMember psiMember, @Nullable PsiType type) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator", "addOutjectedGutter"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator", "addOutjectedGutter"));
        }
        if (psiMember == null || type == null) {
            return;
        }
        Set<InjectionPointDescriptor> outjectedPoints = CdiInjectionUtils.getInjectionPoints(type, CdiInjectionUtils.getInjectionPoints(module));
        if (outjectedPoints.size() > 0) {
            HashSet bindedOutjectedPoints = new HashSet();
            PsiAnnotation[] bindingAnnotations = CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)psiMember);
            for (InjectionPointDescriptor point : outjectedPoints) {
                if (!CdiManager.hasAnnotated(point.getOwner(), bindingAnnotations)) continue;
                bindedOutjectedPoints.add(point);
            }
            CdiInjectionsClassAnnotator.addOutjectedGutterIcon(holder, (Set<InjectionPointDescriptor>)bindedOutjectedPoints, psiMember);
        }
    }

    private static void addInjectedGutterIcon(AnnotationHolder holder, final Set<CdiBeanDescriptor> beanDescriptors, PsiModifierListOwner owner, PsiType type) {
        if (beanDescriptors != null && beanDescriptors.size() > 0) {
            CdiInjectionsClassAnnotator.addInjectedBeanGutterIcon(holder, owner, type, new NotNullLazyValue<Collection<? extends PsiElement>>(){

                @NotNull
                protected Collection<PsiMember> compute() {
                    List list = ContainerUtil.mapNotNull((Collection)beanDescriptors, (Function)new Function<CdiBeanDescriptor, PsiMember>(){

                        public PsiMember fun(CdiBeanDescriptor cdiBeanDescriptor) {
                            if (cdiBeanDescriptor instanceof AbstractCdiBeanDescriptor) {
                                return ((AbstractCdiBeanDescriptor)cdiBeanDescriptor).getAnnotatedItem();
                            }
                            return null;
                        }
                    });
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator$1", "compute"));
                    }
                    return list;
                }
            });
        }
    }

    private static void addOutjectedGutterIcon(AnnotationHolder holder, Set<InjectionPointDescriptor> ips, PsiMember member) {
        List members = ContainerUtil.map(ips, (Function)new Function<InjectionPointDescriptor, PsiModifierListOwner>(){

            public PsiModifierListOwner fun(InjectionPointDescriptor descriptor) {
                return descriptor.getOwner();
            }
        });
        NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.Inject).setTargets((Collection)members).setPopupTitle(CdiBundle.message("gutter.choose.injected.point", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.injection.point", new Object[0])).install(holder, (PsiElement)(member instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)member).getNameIdentifier() : member));
    }

    private static void addInjectedBeanGutterIcon(AnnotationHolder holder, PsiModifierListOwner psiIdentifier, PsiType type, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.CdiBean).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.bean", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to", CdiInjectionsClassAnnotator.getBeanDescription(psiIdentifier, type))).install(holder, CdiInjectionsClassAnnotator.getIdentifingElement(psiIdentifier));
    }

    private static PsiElement getIdentifingElement(@NotNull PsiModifierListOwner psiIdentifier) {
        PsiAnnotation injectAnno;
        if (psiIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiIdentifier", "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator", "getIdentifingElement"));
        }
        PsiModifierList modifierList = psiIdentifier.getModifierList();
        if (modifierList != null && (injectAnno = modifierList.findAnnotation("javax.inject.Inject")) != null) {
            return injectAnno;
        }
        return psiIdentifier;
    }

    private static String getBeanDescription(@NotNull PsiModifierListOwner owner, PsiType type) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator", "getBeanDescription"));
        }
        Collection<PsiClass> psiClasses = CdiCommonUtils.getQualifierClasses(owner);
        String[] names = (String[])ContainerUtil.map2Array(psiClasses, String.class, (Function)new Function<PsiClass, String>(){

            public String fun(PsiClass psiClass) {
                return "@" + psiClass.getName();
            }
        });
        return StringUtil.join((String[])names, (String)" ") + " " + type.getPresentableText();
    }
}

