/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.view;

import com.intellij.cdi.CdiProjectComponent;
import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.FieldProducerBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.MethodProducerBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.diagram.CdiDiagramDataModel;
import com.intellij.cdi.diagram.CdiDiagramProvider;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.toolWindow.tree.nodes.CdiViewSettings;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.cdi.view.CdiInjectionPointsPanel;
import com.intellij.cdi.view.actions.ShowBeansAction;
import com.intellij.cdi.view.actions.ShowGraphAction;
import com.intellij.cdi.view.actions.ShowInjectionPointsAction;
import com.intellij.cdi.view.actions.ShowProducersAction;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiBeansRecursivePanel
extends FinderRecursivePanel<AbstractCdiBeanDescriptor> {
    private final Module myModule;
    private final DefaultActionGroup myActions;
    @Nullable
    private DiagramBuilder builder;
    private ShowGraphAction myShowGraphAction;
    private ShowProducersAction myShowProducersAction;
    private ShowBeansAction myShowBeansAction;
    private ShowInjectionPointsAction myShowInjectionPointsAction;

    public CdiBeansRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, DefaultActionGroup actions) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/cdi/view/CdiBeansRecursivePanel", "<init>"));
        }
        super(parent);
        this.myModule = module;
        this.myActions = actions;
        this.initAdditionalActions(actions);
    }

    private void initAdditionalActions(DefaultActionGroup actions) {
        this.myShowBeansAction = new ShowBeansAction(this);
        this.myShowProducersAction = new ShowProducersAction(this);
        this.myShowGraphAction = new ShowGraphAction(this);
        this.myShowInjectionPointsAction = new ShowInjectionPointsAction(this);
        actions.add((AnAction)this.myShowBeansAction);
        actions.add((AnAction)this.myShowProducersAction);
        actions.add((AnAction)this.myShowGraphAction);
        actions.add((AnAction)this.myShowInjectionPointsAction);
    }

    @Nullable
    protected JComponent createRightComponent(AbstractCdiBeanDescriptor beanDescriptor) {
        if (this.isShowGraph()) {
            return this.createGraphView(beanDescriptor);
        }
        if (this.isShowInjectionPoints() && this.hasChildren(beanDescriptor)) {
            return new CdiInjectionPointsPanel(this, this.getModule());
        }
        return this.getBeanDescriptorInfoPanel(beanDescriptor);
    }

    public JComponent createGraphView(AbstractCdiBeanDescriptor beanDescriptor) {
        PsiClass aClass;
        AbstractCdiBeanDescriptor descriptor = beanDescriptor;
        if (descriptor instanceof ProducerBeanDescriptor && (aClass = descriptor.getAnnotatedItem().getContainingClass()) != null) {
            descriptor = new ManagedBeanDescriptor(aClass);
        }
        this.builder = UmlGraphBuilderFactory.create((Project)this.getProject(), (DiagramProvider)new CdiDiagramProvider(), (Object)descriptor, null);
        Disposer.register((Disposable)this, (Disposable)this.builder);
        this.builder.getView().setFitContentOnResize(true);
        return this.createSimpleBeanGraphView(this.builder);
    }

    private JComponent getBeanDescriptorInfoPanel(AbstractCdiBeanDescriptor beanDescriptor) {
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
        DocumentationComponent component = new DocumentationComponent(manager);
        manager.fetchDocInfo(beanDescriptor.getAnnotatedItem(), component);
        Disposer.register((Disposable)this, (Disposable)component);
        return component;
    }

    @NotNull
    protected String getItemText(AbstractCdiBeanDescriptor beanDescriptor) {
        String name = beanDescriptor.getAnnotatedItem().getName();
        String string = name == null ? "" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/view/CdiBeansRecursivePanel", "getItemText"));
        }
        return string;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, AbstractCdiBeanDescriptor beanDescriptor, int index, boolean selected, boolean hasFocus) {
        PsiField field;
        String s;
        PsiMethod method;
        PsiClass aClass;
        comp.clear();
        comp.setIcon(this.getItemIcon(beanDescriptor));
        if (beanDescriptor instanceof ManagedBeanDescriptor && (aClass = (PsiClass)((ManagedBeanDescriptor)beanDescriptor).getIdentifyingElement()).isValid()) {
            comp.append(aClass.getName());
            CdiBeansRecursivePanel.addQualifierAnnotations(comp, beanDescriptor);
        }
        if (beanDescriptor instanceof MethodProducerBeanDescriptor && (method = (PsiMethod)((MethodProducerBeanDescriptor)beanDescriptor).getIdentifyingElement()).isValid()) {
            s = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)7, (int)2);
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                comp.append(containingClass.getName() + "->", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            }
            comp.append(s);
            CdiBeansRecursivePanel.addQualifierAnnotations(comp, beanDescriptor);
        }
        if (beanDescriptor instanceof FieldProducerBeanDescriptor && (field = (PsiField)((FieldProducerBeanDescriptor)beanDescriptor).getIdentifyingElement()).isValid()) {
            s = PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            comp.append(s);
            CdiBeansRecursivePanel.addQualifierAnnotations(comp, beanDescriptor);
        }
    }

    private static void addQualifierAnnotations(SimpleColoredComponent comp, AbstractCdiBeanDescriptor beanDescriptor) {
        String annotations = CdiBeansRecursivePanel.getQualifierAnnotations(beanDescriptor);
        if (!StringUtil.isEmpty((String)annotations)) {
            comp.append(" " + annotations, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getQualifierAnnotations(AbstractCdiBeanDescriptor beanDescriptor) {
        StringBuilder buffer = new StringBuilder();
        Object item = beanDescriptor.getAnnotatedItem();
        if (item.isValid()) {
            for (PsiAnnotation psiAnnotation : CdiCommonUtils.getQualifierAnnotations(item)) {
                String fqName = psiAnnotation.getQualifiedName();
                if (fqName == null) continue;
                buffer.append("@");
                buffer.append(StringUtil.getShortName((String)fqName));
                buffer.append(" ");
            }
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/view/CdiBeansRecursivePanel", "getQualifierAnnotations"));
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(AbstractCdiBeanDescriptor beanDescriptor) {
        Object item = beanDescriptor.getAnnotatedItem();
        return item.getIcon(0);
    }

    @NotNull
    protected Set<AbstractCdiBeanDescriptor> getListItems(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/view/CdiBeansRecursivePanel", "getListItems"));
        }
        HashSet points = new HashSet();
        HashMap injectionPointOwners = ContainerUtil.newHashMap();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        CdiJamModel model = CdiJamModel.getModel(module);
        for (CdiProduces produces : model.getProduces(scope)) {
            ProducerBeanDescriptor<? extends PsiMember> beanDescriptor;
            if (this.isShowProduces() && (beanDescriptor = CdiDescriptorsFactory.createProducerCdiBeanDescriptor(produces.getPsiElement())) != null) {
                points.add(beanDescriptor);
            }
            CdiBeansRecursivePanel.putIfNotNull(injectionPointOwners, produces.getPsiElement().getContainingClass());
        }
        if (this.isShowBeans()) {
            for (InjectionPointDescriptor ip : CdiInjectionUtils.getInjectionPoints(module, scope)) {
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ip.getOwner(), PsiClass.class);
                if (psiClass != null) {
                    CdiBeansRecursivePanel.putIfNotNull(injectionPointOwners, psiClass);
                }
                for (CdiBeanDescriptor bean : CdiInjectionUtils.getInjectedBeans(ip)) {
                    if (!(bean instanceof AbstractCdiBeanDescriptor)) continue;
                    points.add((AbstractCdiBeanDescriptor)bean);
                }
            }
            for (CdiNamedBean namedBean : model.getNamedBeans(scope)) {
                if (!(namedBean instanceof CdiNamedBean.ClassMapping)) continue;
                CdiBeansRecursivePanel.putIfNotNull(injectionPointOwners, (PsiClass)((CdiNamedBean.ClassMapping)namedBean).getPsiElement());
            }
            for (PsiClass owner : injectionPointOwners.values()) {
                points.add(CdiDescriptorsFactory.createCdiBeanDescriptor(owner));
            }
        }
        HashSet hashSet = points;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/view/CdiBeansRecursivePanel", "getListItems"));
        }
        return hashSet;
    }

    private static void putIfNotNull(@NotNull Map<String, PsiClass> injectionPointOwners, @Nullable PsiClass aClass) {
        if (injectionPointOwners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectionPointOwners", "com/intellij/cdi/view/CdiBeansRecursivePanel", "putIfNotNull"));
        }
        if (aClass != null) {
            ContainerUtil.putIfNotNull((Object)aClass.getQualifiedName(), (Object)aClass, injectionPointOwners);
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        AbstractCdiBeanDescriptor value = (AbstractCdiBeanDescriptor)this.getSelectedValue();
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && value != null) {
            return value.getAnnotatedItem();
        }
        if (this.builder != null) {
            return UmlFileEditorImpl.getData((String)dataId, (DiagramBuilder)this.builder);
        }
        return super.getData(dataId);
    }

    public void dispose() {
        super.dispose();
        this.myActions.remove((AnAction)this.myShowBeansAction);
        this.myActions.remove((AnAction)this.myShowGraphAction);
        this.myActions.remove((AnAction)this.myShowProducersAction);
        this.myActions.remove((AnAction)this.myShowInjectionPointsAction);
    }

    @NotNull
    protected List<AbstractCdiBeanDescriptor> getListItems() {
        ArrayList<AbstractCdiBeanDescriptor> points = new ArrayList<AbstractCdiBeanDescriptor>();
        if (this.myModule != null) {
            points.addAll(this.getListItems(this.myModule));
        } else {
            for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                if (!CdiCommonUtils.isCdiInstalled(module)) continue;
                points.addAll(this.getListItems(module));
            }
        }
        Collections.sort(points, new Comparator<AbstractCdiBeanDescriptor>(){

            @Override
            public int compare(AbstractCdiBeanDescriptor o1, AbstractCdiBeanDescriptor o2) {
                if (o1 instanceof ManagedBeanDescriptor && o2 instanceof ManagedBeanDescriptor) {
                    String value1 = o1.getAnnotatedItem().getName();
                    String value2 = o2.getAnnotatedItem().getName();
                    if (value1 != null && value2 != null) {
                        return value1.compareTo(value2);
                    }
                    return 0;
                }
                if (o1 instanceof ProducerBeanDescriptor && o2 instanceof ProducerBeanDescriptor) {
                    String value1 = o1.getAnnotatedItem().getName();
                    String value2 = o2.getAnnotatedItem().getName();
                    if (value1 != null && value2 != null) {
                        return value1.compareTo(value2);
                    }
                    return 0;
                }
                return o1 instanceof ManagedBeanDescriptor ? 1 : -1;
            }
        });
        ArrayList<AbstractCdiBeanDescriptor> arrayList = points;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/view/CdiBeansRecursivePanel", "getListItems"));
        }
        return arrayList;
    }

    protected boolean hasChildren(AbstractCdiBeanDescriptor beanDescriptor) {
        Object identifyingElement = beanDescriptor.getIdentifyingElement();
        if (identifyingElement.isValid()) {
            if (beanDescriptor instanceof ManagedBeanDescriptor) {
                return CdiInjectionUtils.getInjectionPoints(((ManagedBeanDescriptor)beanDescriptor).getAnnotatedItem()).size() > 0;
            }
            if (beanDescriptor instanceof MethodProducerBeanDescriptor) {
                return CdiInjectionUtils.getInjectionPoints(((MethodProducerBeanDescriptor)beanDescriptor).getAnnotatedItem()).size() > 0;
            }
        }
        return false;
    }

    public Module getModule() {
        return this.myModule;
    }

    public boolean isShowGraph() {
        CdiViewSettings viewSettings = CdiProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings != null && viewSettings.showGraph;
    }

    public boolean isShowBeans() {
        CdiViewSettings viewSettings = CdiProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.showBeans;
    }

    public boolean isShowInjectionPoints() {
        CdiViewSettings viewSettings = CdiProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.showInjectionPoints;
    }

    public boolean isShowProduces() {
        CdiViewSettings viewSettings = CdiProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.showProducers;
    }

    public void setSecondComponent(@Nullable JComponent component) {
        super.setSecondComponent(component);
        if (this.builder != null) {
            final DiagramDataModel model = this.builder.getDataModel();
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    model.refreshDataModel();
                                }
                            });
                        }
                    }, "Refreshing Dependencies...", false, CdiBeansRecursivePanel.this.getProject());
                    CdiBeansRecursivePanel.this.builder.updateGraph();
                    CdiBeansRecursivePanel.this.builder.getView().fitContent();
                }
            });
        }
    }

    private JComponent createSimpleBeanGraphView(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/cdi/view/CdiBeansRecursivePanel", "createSimpleBeanGraphView"));
        }
        builder.getPresentationModel().registerActions();
        Graph2DView view = builder.getView();
        GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)this);
        view.getCanvasComponent().setBackground((Color)JBColor.GRAY);
        return new UmlGraphZoomableViewport(builder);
    }

    private DiagramProvider getProvider(final PsiClass aClass) {
        return new CdiDiagramProvider(){

            @Override
            public DiagramDataModel<CdiBeanDescriptor> createDataModel(@NotNull Project project, @Nullable CdiBeanDescriptor element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cdi/view/CdiBeansRecursivePanel$3", "createDataModel"));
                }
                return new CdiDiagramDataModel(project, this, file, new ManagedBeanDescriptor(aClass));
            }
        };
    }
}

