/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.AbstractSimpleSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.custom.CustomBeanParserModificationTracker;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleLocalModel<T extends PsiElement>
extends AbstractSimpleSpringModel
implements LocalModel<T> {
    private static final Key<CachedValue<Map<String, LazyModelDependenciesGraph>>> MODELS_GRAPH_KEY = Key.create((String)"MODELS_GRAPH_KEY");
    private final NotNullLazyValue<CommonSpringModel> myCustomDiscoveredBeansModel = new VolatileNotNullLazyValue<CommonSpringModel>(){

        @NotNull
        protected CommonSpringModel compute() {
            BeansSpringModel beansSpringModel = new BeansSpringModel(AbstractSimpleLocalModel.this.getModule(), new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    Collection collection = AbstractSimpleLocalModel.this.computeCustomBeans();
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel$1$1", "compute"));
                    }
                    return collection;
                }
            });
            if (beansSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel$1", "compute"));
            }
            return beansSpringModel;
        }
    };

    protected static void addNotNullModel(@NotNull Set<Pair<LocalModel, LocalModelDependency>> models, @Nullable LocalModel model, @NotNull LocalModelDependency dependency) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "addNotNullModel"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "addNotNullModel"));
        }
        if (model != null) {
            models.add((Pair<LocalModel, LocalModelDependency>)Pair.create((Object)model, (Object)dependency));
        }
    }

    private Collection<? extends SpringBeanPointer> computeCustomBeans() {
        LinkedHashSet customSpringComponents = ContainerUtil.newLinkedHashSet();
        for (CustomLocalComponentsDiscoverer discoverer : (CustomLocalComponentsDiscoverer[])Extensions.getExtensions(CustomLocalComponentsDiscoverer.EP_NAME)) {
            customSpringComponents.addAll(discoverer.getCustomComponents(this));
        }
        return BeanService.getInstance().mapSpringBeans(customSpringComponents);
    }

    protected CommonSpringModel getCustomDiscoveredBeansModel() {
        return (CommonSpringModel)this.myCustomDiscoveredBeansModel.getValue();
    }

    @Override
    @NotNull
    public Set<LocalModel> getRelatedLocalModels() {
        Module module = this.getModule();
        if (module == null || module.isDisposed()) {
            Set<LocalModel> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getRelatedLocalModels"));
            }
            return set;
        }
        LazyModelDependenciesGraph graph = AbstractSimpleLocalModel.getOrCreateLocalModelDependenciesGraph(module, this.getActiveProfiles());
        LinkedHashSet visited = ContainerUtil.newLinkedHashSet();
        AbstractSimpleLocalModel.visitRelated(this, graph, visited);
        visited.remove(this);
        LinkedHashSet linkedHashSet = visited;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getRelatedLocalModels"));
        }
        return linkedHashSet;
    }

    private static void visitRelated(@NotNull LocalModel model, @NotNull Graph<LocalModel> graph, @NotNull Set<LocalModel> visited) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "visitRelated"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "visitRelated"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "visitRelated"));
        }
        visited.add(model);
        Iterator out = graph.getOut((Object)model);
        while (out.hasNext()) {
            LocalModel outModel = (LocalModel)out.next();
            if (visited.contains(outModel)) continue;
            AbstractSimpleLocalModel.visitRelated(outModel, graph, visited);
        }
    }

    private static Object[] getDependencies(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getDependencies"));
        }
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        set.add(SpringModificationTrackersManager.getInstance(project).getProfilesModificationTracker());
        set.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        set.add(CustomBeanParserModificationTracker.getInstance());
        set.add(ProjectRootManager.getInstance((Project)project));
        return set.toArray();
    }

    @NotNull
    public static LazyModelDependenciesGraph getOrCreateLocalModelDependenciesGraph(@NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getOrCreateLocalModelDependenciesGraph"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getOrCreateLocalModelDependenciesGraph"));
        }
        String key = SpringProfileUtils.profilesAsString(activeProfiles);
        Map graphsMap = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, MODELS_GRAPH_KEY, AbstractSimpleLocalModel.createGraphProvider(module, activeProfiles), false);
        LazyModelDependenciesGraph lazyModelDependenciesGraph = (LazyModelDependenciesGraph)graphsMap.get(key);
        if (lazyModelDependenciesGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getOrCreateLocalModelDependenciesGraph"));
        }
        return lazyModelDependenciesGraph;
    }

    @NotNull
    private static CachedValueProvider<Map<String, LazyModelDependenciesGraph>> createGraphProvider(final Module module, final Set<String> activeProfiles) {
        CachedValueProvider<Map<String, LazyModelDependenciesGraph>> cachedValueProvider = new CachedValueProvider<Map<String, LazyModelDependenciesGraph>>(){

            public CachedValueProvider.Result<Map<String, LazyModelDependenciesGraph>> compute() {
                ConcurrentFactoryMap<String, LazyModelDependenciesGraph> map = new ConcurrentFactoryMap<String, LazyModelDependenciesGraph>(){

                    protected LazyModelDependenciesGraph create(String key) {
                        return new LazyModelDependenciesGraph(module, activeProfiles);
                    }
                };
                return CachedValueProvider.Result.create((Object)map, (Object[])AbstractSimpleLocalModel.getDependencies(module.getProject()));
            }
        };
        if (cachedValueProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "createGraphProvider"));
        }
        return cachedValueProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getConfig() + "]";
    }

    @NotNull
    protected Object[] getOutsideModelDependencies(@NotNull LocalModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getOutsideModelDependencies"));
        }
        Project project = model.getConfig().getProject();
        ArrayList<Object> dependencies = new ArrayList<Object>(5);
        dependencies.add(model.getConfig());
        SpringModificationTrackersManager springModificationTrackersManager = SpringModificationTrackersManager.getInstance(project);
        dependencies.add(springModificationTrackersManager.getProfilesModificationTracker());
        dependencies.add(springModificationTrackersManager.getMultipleContextsModificationTracker());
        dependencies.add(ProjectRootManager.getInstance((Project)project));
        dependencies.add(PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getOutsideModelDependencies"));
        }
        return objectArray;
    }

    @NotNull
    protected PsiElement[] getConfigs(@NotNull Set<LocalModel> localModels) {
        if (localModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localModels", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getConfigs"));
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array(localModels, PsiElement.class, (Function)new Function<LocalModel, PsiElement>(){

            public PsiElement fun(LocalModel model) {
                return model.getConfig();
            }
        });
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel", "getConfigs"));
        }
        return psiElementArray;
    }
}

