/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.VisitedModelsDelegateProcessor;
import com.intellij.spring.model.QualifierAttribute;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.hash.HashSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedLocalModel
implements CommonSpringModel {
    private volatile Collection<SpringBeanPointer> myLocalBeans;
    private final AtomicNotNullLazyValue<Collection<SpringBeanPointer>> myLocalDomBeans = new AtomicNotNullLazyValue<Collection<SpringBeanPointer>>(){

        @NotNull
        protected Collection<SpringBeanPointer> compute() {
            Collection<SpringBeanPointer> collection = CachedLocalModel.this.calculateDomBeans();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/CachedLocalModel$1", "compute"));
            }
            return collection;
        }
    };
    private final Map<SpringQualifier, List<SpringBeanPointer>> myLocalBeansByQualifier = new ConcurrentFactoryMap<SpringQualifier, List<SpringBeanPointer>>(){

        protected List<SpringBeanPointer> create(SpringQualifier key) {
            return CachedLocalModel.this.computeLocalBeansByQualifier(key);
        }
    };

    @Override
    @NotNull
    public final Collection<SpringBeanPointer> getAllCommonBeans() {
        HashSet pointers = new HashSet();
        pointers.addAll(this.getLocalBeans());
        this.processRelatedModels(new Processor<CommonSpringModel>((Set)pointers){
            final /* synthetic */ Set val$pointers;
            {
                this.val$pointers = set;
            }

            public boolean process(CommonSpringModel model) {
                if (model instanceof CachedLocalModel) {
                    this.val$pointers.addAll(((CachedLocalModel)model).getLocalBeans());
                } else {
                    this.val$pointers.addAll(model.getAllCommonBeans());
                }
                return true;
            }
        });
        Set<SpringBeanPointer> set = Collections.unmodifiableSet(pointers);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/CachedLocalModel", "getAllCommonBeans"));
        }
        return set;
    }

    public Collection<SpringBeanPointer> getLocalBeans() {
        return this.myLocalBeans == null ? (this.myLocalBeans = this.calculateLocalBeans()) : this.myLocalBeans;
    }

    @Override
    @NotNull
    public final Collection<SpringBeanPointer> getAllDomBeans() {
        Collection collection = (Collection)this.myLocalDomBeans.getValue();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/CachedLocalModel", "getAllDomBeans"));
        }
        return collection;
    }

    protected Iterable<CommonSpringModel> getRelatedModels() {
        return Collections.emptySet();
    }

    protected abstract Collection<SpringBeanPointer> calculateLocalBeans();

    protected abstract Collection<SpringBeanPointer> calculateDomBeans();

    @Override
    @NotNull
    public List<SpringBeanPointer> findQualifiedBeans(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/spring/contexts/model/CachedLocalModel", "findQualifiedBeans"));
        }
        SmartList qualifiedBeans = new SmartList();
        qualifiedBeans.addAll((Collection)this.myLocalBeansByQualifier.get(qualifier));
        this.processRelatedModels(new Processor<CommonSpringModel>((List)qualifiedBeans, qualifier){
            final /* synthetic */ List val$qualifiedBeans;
            final /* synthetic */ SpringQualifier val$qualifier;
            {
                this.val$qualifiedBeans = list;
                this.val$qualifier = springQualifier;
            }

            public boolean process(CommonSpringModel model) {
                this.val$qualifiedBeans.addAll(model.findQualifiedBeans(this.val$qualifier));
                return true;
            }
        });
        SmartList smartList = qualifiedBeans.isEmpty() ? Collections.emptyList() : qualifiedBeans;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/CachedLocalModel", "findQualifiedBeans"));
        }
        return smartList;
    }

    private List<SpringBeanPointer> computeLocalBeansByQualifier(SpringQualifier springQualifier) {
        SmartList beans = new SmartList();
        Collection<SpringBeanPointer> pointers = this.getAllCommonBeans();
        for (SpringBeanPointer beanPointer : pointers) {
            Object bean;
            SpringQualifier qualifier;
            if (!beanPointer.isValid() || (qualifier = (bean = beanPointer.getSpringBean()).getSpringQualifier()) == null || !CachedLocalModel.compareQualifiers(qualifier, springQualifier)) continue;
            beans.add(beanPointer);
        }
        return beans.isEmpty() ? Collections.emptyList() : beans;
    }

    private static boolean compareQualifiers(@Nullable SpringQualifier one, @Nullable SpringQualifier two) {
        List<? extends QualifierAttribute> list2;
        int size2;
        if (one == null || two == null) {
            return false;
        }
        if (!Comparing.equal((Object)one.getQualifierType(), (Object)two.getQualifierType())) {
            return false;
        }
        if (!Comparing.equal((String)one.getQualifierValue(), (String)two.getQualifierValue())) {
            return false;
        }
        List<? extends QualifierAttribute> list1 = one.getQualifierAttributes();
        int size1 = list1.size();
        if (size1 != (size2 = (list2 = two.getQualifierAttributes()).size())) {
            return false;
        }
        if (size1 == 0) {
            return true;
        }
        THashSet set = new THashSet(QualifierAttribute.HASHING_STRATEGY);
        set.addAll(list1);
        return set.containsAll(list2);
    }

    public boolean processRelatedModels(final @NotNull Processor<CommonSpringModel> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/CachedLocalModel", "processRelatedModels"));
        }
        Boolean aBoolean = (Boolean)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, (Computable)new Computable<Boolean>(){

            public Boolean compute() {
                for (CommonSpringModel model : CachedLocalModel.this.getRelatedModels()) {
                    if (processor.process((Object)model)) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return aBoolean == null ? true : aBoolean;
    }

    @Override
    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/CachedLocalModel", "processByClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/CachedLocalModel", "processByClass"));
        }
        if (!params.canSearch()) {
            return true;
        }
        return this.processRelatedModels(params, processor);
    }

    @Override
    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/CachedLocalModel", "processByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/CachedLocalModel", "processByName"));
        }
        if (!params.canSearch()) {
            return true;
        }
        return this.processRelatedModels(params, processor);
    }

    protected boolean processRelatedModels(final SpringModelSearchParameters.BeanClass params, final Processor<SpringBeanPointer> processor) {
        return this.processRelatedModels(new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel model) {
                return CachedLocalModel.shouldProcess(model, (Processor<SpringBeanPointer>)processor) ? model.processByClass(params, (Processor<SpringBeanPointer>)processor) : true;
            }
        });
    }

    protected boolean processRelatedModels(final SpringModelSearchParameters.BeanName params, final Processor<SpringBeanPointer> processor) {
        return this.processRelatedModels(new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel model) {
                return CachedLocalModel.shouldProcess(model, (Processor<SpringBeanPointer>)processor) ? model.processByName(params, (Processor<SpringBeanPointer>)processor) : true;
            }
        });
    }

    private static boolean shouldProcess(@NotNull CommonSpringModel model, @NotNull Processor<SpringBeanPointer> processor) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/CachedLocalModel", "shouldProcess"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/CachedLocalModel", "shouldProcess"));
        }
        if (processor instanceof VisitedModelsDelegateProcessor) {
            if (((VisitedModelsDelegateProcessor)processor).hasBeenVisited(model)) {
                return false;
            }
            ((VisitedModelsDelegateProcessor)processor).addVisited(model);
        }
        return true;
    }
}

