/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.util.Function;
import com.intellij.xml.util.PsiElementPointer;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=SpringPresentationProvider.class)
public interface SpringBeanPointer<T extends CommonSpringBean>
extends PsiElementPointer {
    public static final Function<SpringBeanPointer, CommonSpringBean> TO_BEAN = new Function<SpringBeanPointer, CommonSpringBean>(){

        public CommonSpringBean fun(SpringBeanPointer pointer) {
            return pointer.getSpringBean();
        }
    };
    public static final Comparator<SpringBeanPointer> DISPLAY_COMPARATOR = new Comparator<SpringBeanPointer>(){

        @Override
        public int compare(SpringBeanPointer o1, SpringBeanPointer o2) {
            return Comparing.compare((Comparable)((Object)SpringPresentationProvider.getSpringBeanName(o1)), (Comparable)((Object)SpringPresentationProvider.getSpringBeanName(o2)));
        }
    };

    @Nullable
    public String getName();

    public String[] getAliases();

    @NotNull
    public T getSpringBean();

    public boolean isValid();

    public boolean isReferenceTo(@Nullable CommonSpringBean var1);

    public SpringBeanPointer derive(@NotNull String var1);

    @NotNull
    public SpringBeanPointer getBasePointer();

    @Nullable
    public PsiClass getBeanClass();

    public PsiClass[] getEffectiveBeanType();

    public PsiFile getContainingFile();

    public boolean isAbstract();

    @Nullable
    public SpringBeanPointer getParentPointer();
}

