/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringKey;
import com.intellij.spring.model.xml.beans.SpringMap;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class SpringModelVisitor {
    private final Processor<CommonSpringBean> myBeanProcessor = new Processor<CommonSpringBean>(){

        public boolean process(CommonSpringBean bean) {
            return SpringModelVisitor.visitBean(SpringModelVisitor.this, bean);
        }
    };

    @Nullable
    protected Set<String> getActiveProfiles() {
        return null;
    }

    protected boolean visitBean(CommonSpringBean bean) {
        return true;
    }

    protected boolean visitProperty(SpringPropertyDefinition property) {
        return true;
    }

    protected boolean visitConstructorArg(ConstructorArg arg) {
        return true;
    }

    protected boolean visitValueHolder(SpringValueHolder valueHolder) {
        return true;
    }

    protected boolean visitMapEntry(SpringEntry entry) {
        return true;
    }

    protected boolean visitRef(SpringRef ref) {
        return true;
    }

    protected boolean visitIdref(Idref idref) {
        return true;
    }

    private boolean visitChildrenBeans(DomElement parent) {
        if (!DomUtil.hasXml((DomElement)parent)) {
            return true;
        }
        return SpringBeanUtils.getInstance().processChildBeans(parent, true, this.myBeanProcessor);
    }

    public static boolean visitBeans(SpringModelVisitor visitor, Beans beans) {
        Set<String> activeProfiles = visitor.getActiveProfiles();
        if (activeProfiles == null || SpringProfileUtils.isActiveProfile(beans, activeProfiles)) {
            if (!visitor.visitChildrenBeans(beans)) {
                return false;
            }
            for (Beans beansProfiles : beans.getBeansProfiles()) {
                if (SpringModelVisitor.visitBeans(visitor, beansProfiles)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean visitBean(SpringModelVisitor visitor, CommonSpringBean bean) {
        return SpringModelVisitor.visitBean(visitor, bean, true);
    }

    public static boolean visitBean(SpringModelVisitor visitor, CommonSpringBean bean, boolean deep) {
        if (bean instanceof DomSpringBean && !DomUtil.hasXml((DomElement)((DomSpringBean)bean))) {
            return true;
        }
        if (!visitor.visitBean(bean)) {
            return false;
        }
        if (deep) {
            for (SpringPropertyDefinition property : SpringPropertyUtils.getProperties(bean)) {
                if (!visitor.visitProperty(property)) {
                    return false;
                }
                if (!(property instanceof SpringValueHolder) || SpringModelVisitor.visitValueHolder(visitor, (SpringValueHolder)((Object)property))) continue;
                return false;
            }
            if (bean instanceof SpringBean) {
                for (ConstructorArg arg : ((SpringBean)bean).getConstructorArgs()) {
                    if (!visitor.visitConstructorArg(arg)) {
                        return false;
                    }
                    if (SpringModelVisitor.visitValueHolder(visitor, arg)) continue;
                    return false;
                }
            }
            if (bean instanceof ListOrSet && !SpringModelVisitor.visitCollection(visitor, (ListOrSet)((Object)bean))) {
                return false;
            }
            if (bean instanceof SpringMap && !SpringModelVisitor.visitMap(visitor, (SpringMap)((Object)bean))) {
                return false;
            }
        }
        return true;
    }

    private static boolean visitValueHolder(SpringModelVisitor visitor, SpringValueHolder elementsHolder) {
        if (!DomUtil.hasXml((DomElement)elementsHolder)) {
            return true;
        }
        return visitor.visitValueHolder(elementsHolder) && SpringModelVisitor.visitElementsHolder(visitor, elementsHolder);
    }

    private static boolean visitElementsHolder(SpringModelVisitor visitor, SpringElementsHolder elementsHolder) {
        if (!visitor.visitChildrenBeans(elementsHolder)) {
            return false;
        }
        SpringRef ref = elementsHolder.getRef();
        if (DomUtil.hasXml((DomElement)ref) && !visitor.visitRef(ref)) {
            return false;
        }
        Idref idref = elementsHolder.getIdref();
        if (DomUtil.hasXml((DomElement)idref) && !visitor.visitIdref(idref)) {
            return false;
        }
        if (!SpringModelVisitor.visitCollection(visitor, elementsHolder.getList())) {
            return false;
        }
        if (!SpringModelVisitor.visitCollection(visitor, elementsHolder.getSet())) {
            return false;
        }
        if (!SpringModelVisitor.visitCollection(visitor, elementsHolder.getArray())) {
            return false;
        }
        return SpringModelVisitor.visitMap(visitor, elementsHolder.getMap());
    }

    private static boolean visitCollection(SpringModelVisitor visitor, ListOrSet collection) {
        if (!visitor.visitChildrenBeans(collection)) {
            return false;
        }
        for (ListOrSet listOrSet : collection.getSets()) {
            if (SpringModelVisitor.visitCollection(visitor, listOrSet)) continue;
            return false;
        }
        for (ListOrSet listOrSet : collection.getArrays()) {
            if (SpringModelVisitor.visitCollection(visitor, listOrSet)) continue;
            return false;
        }
        for (ListOrSet listOrSet : collection.getLists()) {
            if (SpringModelVisitor.visitCollection(visitor, listOrSet)) continue;
            return false;
        }
        for (SpringMap map : collection.getMaps()) {
            if (SpringModelVisitor.visitMap(visitor, map)) continue;
            return false;
        }
        for (SpringRef ref : collection.getRefs()) {
            if (visitor.visitRef(ref)) continue;
            return false;
        }
        for (Idref idref : collection.getIdrefs()) {
            if (visitor.visitIdref(idref)) continue;
            return false;
        }
        return true;
    }

    private static boolean visitMap(SpringModelVisitor visitor, SpringMap map) {
        if (!DomUtil.hasXml((DomElement)map)) {
            return true;
        }
        for (SpringEntry entry : map.getEntries()) {
            if (!visitor.visitMapEntry(entry)) {
                return false;
            }
            if (!SpringModelVisitor.visitValueHolder(visitor, entry)) {
                return false;
            }
            SpringKey key = entry.getKey();
            if (!DomUtil.hasXml((DomElement)key) || SpringModelVisitor.visitElementsHolder(visitor, key)) continue;
            return false;
        }
        return true;
    }
}

