/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesFileConverter
extends JamSimpleReferenceConverter<Set<PropertiesFile>> {
    public Set<PropertiesFile> fromString(@Nullable String s, JamStringAttributeElement<Set<PropertiesFile>> context) {
        PsiAnnotationMemberValue psiElement = context.getPsiElement();
        if (s != null && psiElement != null) {
            return new HashSet(PropertiesFileConverter.getResourceFiles((PsiElement)psiElement, s, ",", new Condition<PsiFileSystemItem>(){

                public boolean value(PsiFileSystemItem item) {
                    return item instanceof PropertiesFileImpl;
                }
            }));
        }
        return Collections.emptySet();
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<Set<PropertiesFile>> context) {
        PsiReference[] psiReferenceArray = PropertiesFileConverter.getReferences(context);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getReferences(JamStringAttributeElement<Set<PropertiesFile>> context) {
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String s = ElementManipulators.getValueText((PsiElement)psiLiteral);
        return SpringResourcesUtil.getInstance().getReferences(SpringResourcesBuilder.create((PsiElement)psiLiteral, s).fromRoot(s.startsWith("/")).soft(false));
    }

    private static Collection<PropertiesFile> getResourceFiles(@NotNull PsiElement element, @NotNull String s, String delimiter, Condition<PsiFileSystemItem> filter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "getResourceFiles"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "getResourceFiles"));
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        if (element instanceof PsiLiteral) {
            PropertiesFileConverter.addPsiLiteralExpressionReferences((PsiLiteral)element, s, delimiter, references);
        } else {
            try {
                PsiExpression fakeExpression = JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("\"" + s + "\"", element);
                if (fakeExpression instanceof PsiLiteral) {
                    PropertiesFileConverter.addPsiLiteralExpressionReferences((PsiLiteral)fakeExpression, s, delimiter, references);
                }
            }
            catch (IncorrectOperationException fakeExpression) {
                // empty catch block
            }
        }
        Collection files = SpringResourcesUtil.getInstance().getResourceItems(references.toArray(new PsiReference[references.size()]), filter);
        return ContainerUtil.mapNotNull(files, (Function)new NullableFunction<PsiFile, PropertiesFile>(){

            public PropertiesFile fun(PsiFile psiFile) {
                return PropertiesImplUtil.getPropertiesFile((PsiFile)psiFile);
            }
        });
    }

    private static boolean addPsiLiteralExpressionReferences(final @NotNull PsiLiteral element, @NotNull String s, @NotNull String delimiter, final @NotNull List<PsiReference> references) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "addPsiLiteralExpressionReferences"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "addPsiLiteralExpressionReferences"));
        }
        if (delimiter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "addPsiLiteralExpressionReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "addPsiLiteralExpressionReferences"));
        }
        final int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        return SpringReferenceUtils.processSeparatedString(s, delimiter, new PairProcessor<String, Integer>(){

            public boolean process(String s, Integer offset) {
                SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, s).offset(offset + startInElement);
                ContainerUtil.addAll((Collection)references, (Object[])SpringResourcesUtil.getInstance().getReferences(builder));
                return true;
            }
        });
    }
}

