/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.profile;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.SpringProfile;
import com.intellij.util.containers.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="@Profile")
public class SpringJamProfile
extends CommonModelElement.PsiBase
implements JamElement,
SpringProfile,
CommonModelElement {
    private static final JamStringAttributeMeta.Collection<String> VALUE_ATTR_META = JamAttributeMeta.collectionString((String)"value");
    private final JamAnnotationMeta myMeta;
    private final PsiClass myPsiClass;

    public SpringJamProfile(@NotNull PsiAnnotation anno, @NotNull PsiClass psiClass) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/model/jam/profile/SpringJamProfile", "<init>"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/profile/SpringJamProfile", "<init>"));
        }
        Pair<PsiClass, JamAnnotationMeta> definingAnnoMeta = SpringJamProfile.getDefiningAnnoMeta(psiClass, anno);
        if (definingAnnoMeta != null) {
            this.myPsiClass = (PsiClass)definingAnnoMeta.first;
            this.myMeta = (JamAnnotationMeta)definingAnnoMeta.second;
        } else {
            this.myPsiClass = psiClass;
            this.myMeta = null;
        }
    }

    @Nullable
    private static Pair<PsiClass, JamAnnotationMeta> getDefiningAnnoMeta(PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        PsiAnnotation annotation;
        if (psiAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "com/intellij/spring/model/jam/profile/SpringJamProfile", "getDefiningAnnoMeta"));
        }
        String qualifiedName = psiAnnotation.getQualifiedName();
        while (qualifiedName != null && !"org.springframework.context.annotation.Profile".equals(qualifiedName) && (psiClass = JavaPsiFacade.getInstance((Project)psiAnnotation.getProject()).findClass(qualifiedName, GlobalSearchScope.allScope((Project)psiAnnotation.getProject()))) != null && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (boolean)true, (String[])new String[]{"org.springframework.context.annotation.Profile"})) != null) {
            qualifiedName = annotation.getQualifiedName();
        }
        return qualifiedName == null ? null : Pair.create((Object)psiClass, (Object)new JamAnnotationMeta(qualifiedName));
    }

    @Override
    @NotNull
    public Set<String> getNames() {
        HashSet profiles = new HashSet();
        if (this.myMeta != null) {
            for (JamStringAttributeElement element : (List)this.myMeta.getAttribute((PsiModifierListOwner)this.myPsiClass, VALUE_ATTR_META)) {
                String value = (String)element.getValue();
                if (!StringUtil.isNotEmpty((String)value)) continue;
                for (String profile : StringUtil.split((String)value, (String)",")) {
                    profiles.add(profile.trim());
                }
            }
        }
        HashSet hashSet = profiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/profile/SpringJamProfile", "getNames"));
        }
        return hashSet;
    }

    @NotNull
    public PsiModifierListOwner getPsiElement() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/profile/SpringJamProfile", "getPsiElement"));
        }
        return psiClass;
    }
}

