/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

public class SpringValueConditionFactory {
    public static Condition<GenericDomValue> createPropertyNameCondition(final @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "createPropertyNameCondition"));
        }
        return new Condition<GenericDomValue>(){

            public boolean value(GenericDomValue genericDomValue) {
                return SpringValueConditionFactory.checkPropertyName((DomElement)genericDomValue, propertyName);
            }
        };
    }

    public static Condition<GenericDomValue> createBeanPropertyCondition(final @NotNull String beanClass, final String ... propertyNames) {
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "createBeanPropertyCondition"));
        }
        if (propertyNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyNames", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "createBeanPropertyCondition"));
        }
        return new Condition<GenericDomValue>(){

            public boolean value(GenericDomValue genericDomValue) {
                for (String propertyName : propertyNames) {
                    if (!SpringValueConditionFactory.checkPropertyName((DomElement)genericDomValue, propertyName)) continue;
                    return SpringValueConditionFactory.checkBeanClass((DomElement)genericDomValue, beanClass);
                }
                return false;
            }
        };
    }

    public static Condition<GenericDomValue> createBeanClassCondition(final @NotNull String beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "createBeanClassCondition"));
        }
        return new Condition<GenericDomValue>(){

            public boolean value(GenericDomValue genericDomValue) {
                return SpringValueConditionFactory.checkBeanClass((DomElement)genericDomValue, beanClass);
            }
        };
    }

    public static Condition<GenericDomValue> createBeanClassConstructorArgCondition(final @NotNull String beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "createBeanClassConstructorArgCondition"));
        }
        return new Condition<GenericDomValue>(){

            public boolean value(GenericDomValue genericDomValue) {
                return SpringValueConditionFactory.isConstructorArg(genericDomValue) && SpringValueConditionFactory.checkBeanClass((DomElement)genericDomValue, beanClass);
            }
        };
    }

    private static boolean isConstructorArg(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "isConstructorArg"));
        }
        return genericDomValue.getParentOfType(ConstructorArg.class, false) != null;
    }

    private static boolean checkBeanClass(@NotNull DomElement element, @NotNull String beanClassName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "checkBeanClass"));
        }
        if (beanClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClassName", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "checkBeanClass"));
        }
        DomSpringBean springBean = SpringConverterUtil.getCurrentBean(element);
        if (springBean == null) {
            return false;
        }
        PsiClass beanClass = springBean.getBeanClass();
        return InheritanceUtil.isInheritor((PsiClass)beanClass, (String)beanClassName);
    }

    private static boolean checkPropertyName(@NotNull DomElement element, @NotNull String propertyName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "checkPropertyName"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/model/values/converters/SpringValueConditionFactory", "checkPropertyName"));
        }
        SpringProperty springProperty = (SpringProperty)element.getParentOfType(SpringProperty.class, false);
        return springProperty != null && propertyName.equals(springProperty.getName().getStringValue());
    }
}

