/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.ProjectTopics;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class SpringBaseView
extends SimpleToolWindowPanel {
    protected final Project myProject;
    protected FinderRecursivePanel myRootPanel;

    protected SpringBaseView(Project project) {
        super(false, true);
        this.myProject = project;
        this.refreshContentPanel();
    }

    protected abstract FinderRecursivePanel createRootPanel();

    private void refreshContentPanel() {
        this.myRootPanel = this.createRootPanel();
        this.myRootPanel.init();
        this.setContent((JComponent)this.myRootPanel);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myRootPanel);
    }

    protected void performFullUpdate() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                FinderRecursivePanel oldPanel = SpringBaseView.this.myRootPanel;
                SpringBaseView.this.remove((Component)oldPanel);
                Disposer.dispose((Disposable)oldPanel);
                SpringBaseView.this.refreshContentPanel();
            }
        }, ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    protected void performDetailsUpdate() {
        FinderRecursivePanel panel = this.myRootPanel;
        while (true) {
            if (!(panel.getSecondComponent() instanceof FinderRecursivePanel)) break;
            panel = (FinderRecursivePanel)panel.getSecondComponent();
        }
        panel.updateRightComponent(true);
    }

    private void updateSelectedPath(Object ... pathToSelect) {
        this.myRootPanel.updateSelectedPath(pathToSelect);
    }

    protected MessageBusConnection installProjectModuleListener() {
        ProjectWideFacetAdapter<SpringFacet> myProjectWideFacetAdapter = new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetAdded(SpringFacet facet) {
                SpringBaseView.this.performFullUpdate();
            }

            public void facetRemoved(SpringFacet facet) {
                SpringBaseView.this.performFullUpdate();
            }

            public void facetConfigurationChanged(SpringFacet facet) {
                SpringBaseView.this.performFullUpdate();
            }
        };
        ProjectWideFacetListenersRegistry.getInstance((Project)this.myProject).registerListener(SpringFacet.FACET_TYPE_ID, (ProjectWideFacetListener)myProjectWideFacetAdapter, (Disposable)this.myProject);
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                SpringBaseView.this.performFullUpdate();
            }
        });
        messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/toolWindow/SpringBaseView$4", "moduleAdded"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/toolWindow/SpringBaseView$4", "moduleAdded"));
                }
                SpringBaseView.this.performFullUpdate();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/toolWindow/SpringBaseView$4", "moduleRemoved"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/toolWindow/SpringBaseView$4", "moduleRemoved"));
                }
                SpringBaseView.this.performFullUpdate();
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/toolWindow/SpringBaseView$4", "modulesRenamed"));
                }
                if (modules == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/spring/toolWindow/SpringBaseView$4", "modulesRenamed"));
                }
                if (oldNameProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNameProvider", "com/intellij/spring/toolWindow/SpringBaseView$4", "modulesRenamed"));
                }
                SpringBaseView.this.performFullUpdate();
            }
        });
        return messageBusConnection;
    }

    protected static void select(Project project, final Object[] pathToSelect, final boolean requestFocus, final String tabName) {
        final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Spring");
        assert (toolWindow != null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ContentManager contentManager = toolWindow.getContentManager();
                Content content = contentManager.findContent(tabName);
                Content selected = contentManager.getSelectedContent();
                assert (selected != null);
                contentManager.removeFromSelection(selected);
                contentManager.addSelectedContent(content);
                contentManager.setSelectedContent(content, requestFocus);
                SpringBaseView springMvcView = (SpringBaseView)((Object)content.getComponent());
                springMvcView.updateSelectedPath(pathToSelect);
            }
        };
        if (requestFocus) {
            toolWindow.activate(runnable);
        } else {
            runnable.run();
        }
    }
}

