/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.layout.EdgeLayout;
import com.intellij.openapi.graph.layout.LayoutGraph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.view.Graph2D;
import java.util.Collection;
import java.util.List;
import org.jetbrains.idea.maven.ext.uml.MavenUmlDataKeys;
import org.jetbrains.idea.maven.ext.uml.MavenUmlDataModel;
import org.jetbrains.idea.maven.ext.uml.MavenUmlNode;

public class MavenLayouter
implements Layouter {
    public double hGap = 30.0;
    public double vGap = 10.0;

    public boolean canLayout(LayoutGraph graph) {
        return true;
    }

    public void doLayout(LayoutGraph graph) {
        DiagramBuilder builder = (DiagramBuilder)graph.getDataProvider((Object)"GRAPH_BUILDER").get((Object)"");
        MavenUmlNode root = ((MavenUmlDataModel)builder.getDataModel()).getRoot();
        this.place(builder, root, 0.0, 0.0);
        MavenLayouter.placeEdges(builder);
    }

    private static void placeEdges(DiagramBuilder builder) {
        Collection edges = builder.getEdgeObjects();
        Graph2D graph = builder.getGraph();
        for (DiagramEdge edge : edges) {
            double y1;
            Node src = builder.getNode(edge.getSource());
            Node trg = builder.getNode(edge.getTarget());
            Edge e = builder.getEdge(edge);
            EdgeLayout layout = graph.getLayout(e);
            double x0 = graph.getCenterX(src);
            double y0 = graph.getCenterY(src);
            if (y0 == (y1 = graph.getCenterY(trg))) continue;
            layout.clearPoints();
            layout.addPoint(x0, y1);
        }
    }

    private void place(DiagramBuilder builder, MavenUmlNode root, double x, double y) {
        Node node = builder.getNode((DiagramNode)root);
        Graph2D graph = builder.getGraph();
        graph.setLocation(node, x, y);
        double h = graph.getHeight(node);
        x += graph.getWidth(node) + this.hGap;
        for (MavenUmlNode childNode : (List)root.getUserData(MavenUmlDataKeys.CHILD_NODES)) {
            this.place(builder, childNode, x, y);
            y += (h + this.vGap) * (double)((Integer)childNode.getUserData(MavenUmlDataKeys.TREE_HEIGHT)).intValue();
        }
    }

    public double getHGap() {
        return this.hGap;
    }

    public void setHGap(double hGap) {
        this.hGap = hGap;
    }

    public double getVGap() {
        return this.vGap;
    }

    public void setVGap(double vGap) {
        this.vGap = vGap;
    }
}

