/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenUmlDataKeys;
import org.jetbrains.idea.maven.ext.uml.MavenUmlEdge;
import org.jetbrains.idea.maven.ext.uml.MavenUmlNode;
import org.jetbrains.idea.maven.ext.uml.MavenUmlNodeHighlighter;
import org.jetbrains.idea.maven.ext.uml.MavenUmlProvider;
import org.jetbrains.idea.maven.ext.uml.MavenUmlVisibilityManager;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;

public class MavenUmlDataModel
extends DiagramDataModel<MavenElement> {
    private final MavenElement myElement;
    private ArrayList<DiagramNode<MavenElement>> myNodes = new ArrayList();
    private ArrayList<DiagramEdge<MavenElement>> myEdges = new ArrayList();
    private MavenUmlNode myRoot;
    private Map<MavenUmlNode, List<MavenUmlEdge>> conflicted = new HashMap<MavenUmlNode, List<MavenUmlEdge>>();
    private Map<MavenUmlNode, List<MavenUmlEdge>> duplicated = new HashMap<MavenUmlNode, List<MavenUmlEdge>>();
    private VisibilityLevel myVisibility;

    public MavenUmlDataModel(Project project, MavenElement element) {
        super(project, DiagramProvider.findByID((String)"MAVEN"));
        this.myElement = element;
    }

    public void refreshDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.conflicted.clear();
        this.duplicated.clear();
        this.myVisibility = this.getVisibilityManager().getCurrentVisibilityLevel();
        this.myRoot = new MavenUmlNode(this.myElement);
        this.addNodesRecursively(this.myRoot);
        this.myRoot.putUserData(MavenUmlDataKeys.TREE_HEIGHT, MavenUmlDataModel.getNodeHeight(this.myRoot));
        this.addConflictEdges();
        this.addDuplicatedEdges();
    }

    private void addConflictEdges() {
        MavenUmlNodeHighlighter highlighter = MavenUmlProvider.getInstance().getExtras().getNodeHighlighter();
        if (highlighter != null) {
            for (MavenUmlNode node : this.conflicted.keySet()) {
                List nodes = highlighter.onNodeSelected(Arrays.asList(new DiagramNode[]{node}), this);
                if (nodes == null) continue;
                for (DiagramNode to : nodes) {
                    to.putUserData(MavenUmlDataKeys.CONFLICTED_WITH, (Object)node);
                    if (to == node) continue;
                    MavenUmlEdge e = new MavenUmlEdge(node, (MavenUmlNode)to, MavenArtifactState.CONFLICT);
                    this.conflicted.get((Object)node).add(e);
                }
            }
        }
    }

    private void addDuplicatedEdges() {
        MavenUmlNodeHighlighter highlighter = MavenUmlProvider.getInstance().getExtras().getNodeHighlighter();
        if (highlighter != null) {
            for (MavenUmlNode node : this.duplicated.keySet()) {
                List nodes = highlighter.onNodeSelected(Arrays.asList(new DiagramNode[]{node}), this);
                if (nodes == null) continue;
                for (DiagramNode to : nodes) {
                    to.putUserData(MavenUmlDataKeys.DUPLICATED_WITH, (Object)node);
                    if (to == node) continue;
                    MavenUmlEdge e = new MavenUmlEdge(node, (MavenUmlNode)to, MavenArtifactState.DUPLICATE);
                    this.duplicated.get((Object)node).add(e);
                }
            }
        }
    }

    private static int getNodeHeight(MavenUmlNode node) {
        List nodes = (List)node.getUserData(MavenUmlDataKeys.CHILD_NODES);
        int h = 0;
        if (nodes == null || nodes.size() == 0) {
            h = 1;
        } else {
            for (MavenUmlNode child : nodes) {
                h += MavenUmlDataModel.getNodeHeight(child);
            }
        }
        node.putUserData(MavenUmlDataKeys.TREE_HEIGHT, h);
        return h;
    }

    private void addNodesRecursively(MavenUmlNode node) {
        this.myNodes.add((DiagramNode<MavenElement>)node);
        MavenArtifactState state = node.getIdentifyingElement().getState();
        if (state == MavenArtifactState.CONFLICT) {
            this.conflicted.put(node, new ArrayList());
        } else if (state == MavenArtifactState.DUPLICATE) {
            this.duplicated.put(node, new ArrayList());
        }
        ArrayList<MavenUmlNode> kids = new ArrayList<MavenUmlNode>();
        node.putUserData(MavenUmlDataKeys.CHILD_NODES, kids);
        for (MavenElement child : node.getIdentifyingElement().getChildren()) {
            if (!MavenUmlDataModel.suite(child.getScope(), this.myVisibility)) continue;
            MavenUmlNode to = new MavenUmlNode(child);
            kids.add(to);
            to.putUserData(MavenUmlDataKeys.PARENT_NODE, (Object)node);
            this.myEdges.add((DiagramEdge<MavenElement>)new MavenUmlEdge(node, to));
            this.addNodesRecursively(to);
        }
    }

    private static boolean suite(MavenArtifactScope scope, VisibilityLevel visibility) {
        if (visibility == MavenUmlVisibilityManager.ALL || scope == null) {
            return true;
        }
        switch (scope) {
            case COMPILE: {
                return visibility == MavenUmlVisibilityManager.COMPILE;
            }
            case PROVIDED: {
                return visibility == MavenUmlVisibilityManager.PROVIDED;
            }
            case RUNTIME: {
                return visibility == MavenUmlVisibilityManager.RUNTIME;
            }
            case TEST: {
                return visibility == MavenUmlVisibilityManager.TEST;
            }
        }
        return false;
    }

    @NotNull
    public Collection<DiagramNode<MavenElement>> getNodes() {
        ArrayList<DiagramNode<MavenElement>> arrayList = this.myNodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/uml/MavenUmlDataModel", "getNodes"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<DiagramEdge<MavenElement>> getEdges() {
        ArrayList<DiagramEdge<MavenElement>> arrayList = this.myEdges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/uml/MavenUmlDataModel", "getEdges"));
        }
        return arrayList;
    }

    @NotNull
    public String getNodeName(DiagramNode<MavenElement> n) {
        String string = ((MavenElement)n.getIdentifyingElement()).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/uml/MavenUmlDataModel", "getNodeName"));
        }
        return string;
    }

    public DiagramNode<MavenElement> addElement(MavenElement element) {
        MavenUmlNode node;
        if (element != null && !this.myNodes.contains((Object)(node = new MavenUmlNode(element)))) {
            this.myNodes.add((DiagramNode<MavenElement>)node);
            return node;
        }
        return null;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = MavenProjectsManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (modificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/uml/MavenUmlDataModel", "getModificationTracker"));
        }
        return modificationTracker;
    }

    public void dispose() {
    }

    public MavenUmlNode getRoot() {
        return this.myRoot;
    }

    @Nullable
    public List<MavenUmlEdge> getConflictedEdgesForNode(MavenUmlNode node) {
        MavenUmlNode parent = (MavenUmlNode)((Object)node.getUserData(MavenUmlDataKeys.CONFLICTED_WITH));
        if (parent != null) {
            return this.conflicted.get((Object)parent);
        }
        return null;
    }

    @Nullable
    public List<MavenUmlEdge> getDuplicatedEdgesForNode(MavenUmlNode node) {
        MavenUmlNode parent = (MavenUmlNode)((Object)node.getUserData(MavenUmlDataKeys.DUPLICATED_WITH));
        if (parent != null) {
            return this.duplicated.get((Object)parent);
        }
        return null;
    }

    public void addConflicted(MavenUmlEdge edge) {
        this.myEdges.add((DiagramEdge<MavenElement>)edge);
    }

    public void addDuplicated(MavenUmlEdge edge) {
        this.myEdges.add((DiagramEdge<MavenElement>)edge);
    }

    public void removeAllExtraEdges() {
        for (List<MavenUmlEdge> edges : this.conflicted.values()) {
            this.myEdges.removeAll(edges);
        }
        for (List<MavenUmlEdge> edges : this.duplicated.values()) {
            this.myEdges.removeAll(edges);
        }
    }
}

