/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.PlatformColors;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class MavenUmlElementManager
extends AbstractDiagramElementManager<MavenElement> {
    private static final SimpleTextAttributes PROJECT_ATTRS = new SimpleTextAttributes(1, PlatformColors.BLUE);

    public MavenElement findInDataContext(DataContext context) {
        MavenProject mavenProject;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        if (MavenDataKeys.MAVEN_PROJECTS_TREE.getData(context) == null) {
            FileEditor editor = (FileEditor)DataKeys.FILE_EDITOR.getData(context);
            if (editor == null) {
                return null;
            }
            PsiFile psiFile = (PsiFile)DataKeys.PSI_FILE.getData(context);
            if (psiFile == null || !"pom.xml".equalsIgnoreCase(psiFile.getName())) {
                return null;
            }
        }
        return (mavenProject = MavenActionUtil.getMavenProject((DataContext)context)) == null ? null : new MavenElement(project, mavenProject, null);
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof MavenElement;
    }

    public String getElementTitle(MavenElement element) {
        return element.getName();
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof MavenElement) {
            MavenElement mavenElement = (MavenElement)element;
            int style = 1;
            if (mavenElement.getState() == MavenArtifactState.EXCLUDED) {
                style = 4;
            }
            SimpleTextAttributes attr = new SimpleTextAttributes(style, mavenElement.getTitleColor());
            return new SimpleColoredText(mavenElement.getName(), attr);
        }
        return null;
    }

    public String getNodeTooltip(MavenElement element) {
        return null;
    }
}

