/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.EditNodeHandler;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenLayouter;
import org.jetbrains.idea.maven.ext.uml.MavenUmlNodeHighlighter;

public class MavenUmlExtras
extends DiagramExtras<MavenElement> {
    private static final MavenUmlNodeHighlighter NODE_HIGHLIGHTER = new MavenUmlNodeHighlighter();
    private static List<AnAction> actions = null;
    private static final EditNodeHandler<MavenElement> EDIT_HANDLER = new EditNodeHandler<MavenElement>(){

        public void doEdit(DiagramNode<MavenElement> node, DiagramPresentationModel presentationModel) {
            ((MavenElement)node.getIdentifyingElement()).navigate(true);
        }
    };

    public Object getData(String dataId, List<DiagramNode<MavenElement>> umlNodes, DiagramBuilder builder) {
        if (umlNodes.isEmpty()) {
            return null;
        }
        MavenElement mavenElement = (MavenElement)umlNodes.get(0).getIdentifyingElement();
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return mavenElement.getNavigatable();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return mavenElement.getVirtualFile();
        }
        return null;
    }

    public EditNodeHandler<MavenElement> getEditNodeHandler() {
        return EDIT_HANDLER;
    }

    public Layouter getCustomLayouter(Graph2D graph, Project project) {
        return new MavenLayouter();
    }

    public MavenUmlNodeHighlighter getNodeHighlighter() {
        return NODE_HIGHLIGHTER;
    }

    public List<AnAction> getExtraActions() {
        if (actions == null) {
            actions = new ArrayList<AnAction>(super.getExtraActions());
            actions.add(ActionManager.getInstance().getAction("Maven.Uml.Exclude"));
        }
        return actions;
    }
}

