/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.extras.UmlNodeHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenUmlDataKeys;
import org.jetbrains.idea.maven.ext.uml.MavenUmlDataModel;
import org.jetbrains.idea.maven.ext.uml.MavenUmlEdge;
import org.jetbrains.idea.maven.ext.uml.MavenUmlNode;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;

public class MavenUmlNodeHighlighter
implements UmlNodeHighlighter<MavenElement> {
    private static final Key<Balloon> BALLON_KEY = Key.create((String)"MAVEN_UML_BALLON_KEY");

    public List<DiagramNode<MavenElement>> onNodeSelected(List<DiagramNode<MavenElement>> selectedNodes, DiagramDataModel<MavenElement> dataModel) {
        if (selectedNodes.size() == 1) {
            MavenElement element;
            MavenArtifactNode artifactNode;
            DiagramNode<MavenElement> sel = selectedNodes.get(0);
            DiagramNode<MavenElement> selected = (DiagramNode<MavenElement>)sel.getUserData(MavenUmlDataKeys.CONFLICTED_WITH);
            if (selected == null && (selected = (DiagramNode)sel.getUserData(MavenUmlDataKeys.DUPLICATED_WITH)) == null) {
                selected = sel;
            }
            if ((artifactNode = (element = (MavenElement)selected.getIdentifyingElement()).getArtifact()) != null && element.getState() == MavenArtifactState.CONFLICT || element.getState() == MavenArtifactState.DUPLICATE) {
                MavenArtifact relatedArtifact = artifactNode.getRelatedArtifact();
                Collection nodes = dataModel.getNodes();
                ArrayList<DiagramNode<MavenElement>> result = new ArrayList<DiagramNode<MavenElement>>();
                result.add(selected);
                for (DiagramNode node : nodes) {
                    MavenArtifactNode artifact;
                    if (node == selected || (artifact = ((MavenElement)node.getIdentifyingElement()).getArtifact()) == null || artifact.getArtifact() != relatedArtifact) continue;
                    result.add((DiagramNode<MavenElement>)node);
                }
                return result;
            }
        }
        return null;
    }

    public void selectionChanged(final DiagramBuilder builder) {
        Graph2D graph = builder.getGraph();
        MavenUmlDataModel dataModel = (MavenUmlDataModel)builder.getDataModel();
        List list = Utils.getSelectedNodesExceptNotes((DiagramBuilder)builder);
        if (list.size() == 1) {
            EdgeRealizer realizer;
            Edge e;
            double y1;
            double x0;
            Node trg;
            Node src;
            final MavenUmlNode node = (MavenUmlNode)((Object)list.get(0));
            if (builder.getView().getCanvasComponent().isShowing()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Node n;
                        Balloon oldBalloon = (Balloon)builder.getUserData(BALLON_KEY);
                        if (oldBalloon != null) {
                            oldBalloon.hide();
                        }
                        if ((n = builder.getNode((DiagramNode)node)) == null) {
                            return;
                        }
                        Point point = Utils.getNodeCoordinatesOnScreen((Node)n, (Graph2DView)builder.getView());
                        double shift = builder.getGraph().getRealizer(n).getWidth() / 2.0;
                        point.setLocation((double)point.x + shift, (double)(point.y - 2));
                        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(node.getIdentifyingElement().getDescription(), null, (Color)new JBColor(new Color(233, 233, 77, 180), new Color(93, 87, 78)), null).setHideOnFrameResize(true).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon();
                        Disposer.register((Disposable)builder, (Disposable)balloon);
                        builder.putUserData(BALLON_KEY, (Object)balloon);
                        balloon.show(new RelativePoint(point), Balloon.Position.above);
                    }
                });
            }
            List<MavenUmlEdge> conflicted = dataModel.getConflictedEdgesForNode(node);
            List<MavenUmlEdge> duplicated = dataModel.getDuplicatedEdgesForNode(node);
            if (conflicted != null) {
                for (MavenUmlEdge edge : conflicted) {
                    dataModel.addConflicted(edge);
                }
                builder.updateGraph();
                for (MavenUmlEdge edge : conflicted) {
                    src = builder.getNode(edge.getSource());
                    trg = builder.getNode(edge.getTarget());
                    x0 = graph.getCenterX(src);
                    y1 = graph.getCenterY(trg);
                    e = builder.getEdge((DiagramEdge)edge);
                    realizer = graph.getRealizer(e);
                    realizer.clearPoints();
                    realizer.addPoint(x0, y1);
                }
                if (duplicated == null) {
                    return;
                }
            }
            if (duplicated != null) {
                for (MavenUmlEdge edge : duplicated) {
                    dataModel.addDuplicated(edge);
                }
                builder.updateGraph();
                for (MavenUmlEdge edge : duplicated) {
                    src = builder.getNode(edge.getSource());
                    trg = builder.getNode(edge.getTarget());
                    x0 = graph.getCenterX(src);
                    y1 = graph.getCenterY(trg);
                    e = builder.getEdge((DiagramEdge)edge);
                    realizer = graph.getRealizer(e);
                    realizer.clearPoints();
                    realizer.addPoint(x0, y1);
                }
                return;
            }
        }
        dataModel.removeAllExtraEdges();
        builder.updateGraph();
    }
}

