/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramActionsManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.DiagramActionWithPreparation;
import com.intellij.diagram.actions.PopupCallback;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.HashSet;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramAction
extends AnAction
implements Toggleable {
    public DiagramAction() {
        this.setEnabledInModalContext(true);
    }

    protected DiagramAction(String name, @Nullable String description, @Nullable Icon icon) {
        super(name, description, icon);
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        DiagramBuilder builder = DiagramAction.getBuilder(e);
        e.getPresentation().setEnabled(builder != null && this.isEnabled(e, builder));
        if (builder != null) {
            e.getPresentation().putClientProperty("selected", (Object)this.isSelected(e, builder));
        }
    }

    public abstract void perform(AnActionEvent var1);

    public final void actionPerformed(final AnActionEvent e) {
        final DiagramBuilder builder = DiagramAction.getBuilder(e);
        if (builder != null) {
            final Project project = builder.getProject();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            final DiagramState oldState = new DiagramState(builder);
            if (this instanceof DiagramActionWithPreparation) {
                final DiagramActionWithPreparation actionWithPreparation = (DiagramActionWithPreparation)this;
                final Object data = new ReadAction<Object>(){

                    protected void run(@NotNull Result<Object> result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diagram/DiagramAction$1", "run"));
                        }
                        result.setResult(actionWithPreparation.prepare(e));
                    }
                }.execute().getResultObject();
                if (data != null) {
                    new WriteCommandAction(project, this.getActionName(), this.getActionGroupId(e), new PsiFile[0]){

                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diagram/DiagramAction$2", "run"));
                            }
                            PsiFile[] files = DiagramAction.this.getAffectedFiles(e);
                            actionWithPreparation.execute(builder, data, e);
                            DiagramActionsManager.getInstance(project).notifyUmlListeners(builder, oldState, files);
                            builder.notifyOtherBuilders();
                        }
                    }.execute();
                }
            } else if (this.isUndoable(e)) {
                new WriteCommandAction(project, this.getActionName(), this.getActionGroupId(e), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diagram/DiagramAction$3", "run"));
                        }
                        PsiFile[] files = DiagramAction.this.getAffectedFiles(e);
                        DiagramAction.this.perform(e);
                        DiagramActionsManager.getInstance(project).notifyUmlListeners(builder, oldState, files);
                        builder.notifyOtherBuilders();
                    }
                }.execute();
            } else {
                this.perform(e);
                builder.notifyOtherBuilders();
            }
        }
    }

    public PsiFile[] getAffectedFiles(AnActionEvent e) {
        return PsiFile.EMPTY_ARRAY;
    }

    @Nullable
    public static DiagramBuilder getBuilder(AnActionEvent e) {
        return DiagramAction.getBuilderFromActionEvent(e);
    }

    @Nullable
    public static DiagramProvider getProvider(AnActionEvent e) {
        DiagramBuilder builder = DiagramAction.getBuilder(e);
        return builder == null ? null : builder.getProvider();
    }

    @Nullable
    public static DiagramDataModel getDataModel(AnActionEvent e) {
        DiagramBuilder builder = DiagramAction.getBuilder(e);
        return builder == null ? null : builder.getDataModel();
    }

    @Nullable
    public static DiagramBuilder getBuilderFromActionEvent(AnActionEvent e) {
        return (DiagramBuilder)DiagramDataKeys.BUILDER.getData(e.getDataContext());
    }

    @Nullable
    public static Graph2D getGraph(AnActionEvent e) {
        DiagramBuilder builder = DiagramAction.getBuilder(e);
        return builder == null ? null : builder.getGraph();
    }

    public boolean isSelected(AnActionEvent e, DiagramBuilder b) {
        return false;
    }

    public boolean isEnabled(AnActionEvent e, DiagramBuilder b) {
        return true;
    }

    public boolean isUndoable(AnActionEvent e) {
        return true;
    }

    @Nullable
    public String getActionGroupId(AnActionEvent e) {
        return null;
    }

    public abstract String getActionName();

    public static List<DiagramNode> getSelectedNodes(AnActionEvent e) {
        return DiagramAction.getSelectedNodes(DiagramAction.getBuilder(e));
    }

    public static List<DiagramNode> getSelectedNodes(DiagramBuilder builder) {
        ArrayList<DiagramNode> selected = new ArrayList<DiagramNode>();
        if (builder != null) {
            for (DiagramNode umlNode : builder.getNodeObjects()) {
                Node node = builder.getNode(umlNode);
                if (node == null || !builder.getGraph().isSelected(node)) continue;
                selected.add(umlNode);
            }
        }
        return selected;
    }

    public static List<DiagramNode> getSelectedNodesExceptNotes(AnActionEvent e) {
        DiagramBuilder builder = DiagramAction.getBuilder(e);
        return builder == null ? Collections.emptyList() : Utils.getSelectedNodesExceptNotes(builder);
    }

    public static Runnable createCallback(final DiagramBuilder builder, final @NotNull PopupCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/diagram/DiagramAction", "createCallback"));
        }
        return new Runnable(){

            @Override
            public void run() {
                final DiagramState oldState = new DiagramState(builder);
                final Project project = builder.getProject();
                new WriteCommandAction(project, callback.getActionName(), callback.getGroupName(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diagram/DiagramAction$4$1", "run"));
                        }
                        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                        PsiFile[] files = callback.getAffectedFiles();
                        callback.run();
                        DiagramActionsManager.getInstance(project).notifyUmlListeners(builder, oldState, files);
                    }
                }.execute();
            }
        };
    }

    public static <T> T performCommand(final DiagramBuilder builder, final Callable<T> call, String commandName, @Nullable String groupName, PsiElement ... elements) {
        final PsiFile[] files = DiagramAction.getPsiFiles(elements);
        final Project project = builder.getProject();
        CommandProcessor processor = CommandProcessor.getInstance();
        if (processor.getCurrentCommand() != null) {
            processor.setCurrentCommandName(commandName);
            processor.setCurrentCommandGroupId((Object)groupName);
        }
        return (T)new WriteCommandAction<T>(project, commandName, groupName, files){

            protected void run(Result<T> result) throws Throwable {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                DiagramState oldState = new DiagramState(builder);
                result.setResult(call.call());
                DiagramActionsManager.getInstance(project).notifyUmlListeners(builder, oldState, files);
            }
        }.execute().getResultObject();
    }

    private static PsiFile[] getPsiFiles(PsiElement[] elements) {
        if (elements.length == 0) {
            return PsiFile.EMPTY_ARRAY;
        }
        HashSet files = new HashSet();
        for (PsiElement element : elements) {
            if (element instanceof PsiFile) {
                files.add((PsiFile)element);
                continue;
            }
            PsiFile file = element.getContainingFile();
            if (file == null) continue;
            files.add(file);
        }
        return files.toArray(new PsiFile[files.size()]);
    }

    public static void performCommand(DiagramBuilder builder, final Runnable run, String commandName, @Nullable String groupName, PsiElement ... elements) {
        Callable<Object> call = new Callable<Object>(){

            @Override
            @Nullable
            public Object call() throws Exception {
                run.run();
                return null;
            }
        };
        DiagramAction.performCommand(builder, call, commandName, groupName, elements);
    }

    public static void showNotification(String message, DiagramBuilder builder) {
        DiagramAction.showNotification(message, new RelativePoint(Utils.getGraphCenterOnScreen(builder.getGraph())));
    }

    public static void showNotification(String message, DiagramNode<?> node, DiagramBuilder builder) {
        Point point = Utils.getNodeCoordinatesOnScreen(builder.getNode(node), builder.getView());
        DiagramAction.showNotification(message, new RelativePoint(point));
    }

    public static void showNotification(String message, RelativePoint point) {
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.INFO, null).setFadeoutTime(2000L).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon().show(point, Balloon.Position.above);
    }
}

