/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.Utils;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramDataModel<T>
extends SimpleModificationTracker
implements UserDataHolder,
Disposable {
    private final Project myProject;
    private final DiagramVisibilityManager myVisibilityManager;
    private final DiagramProvider<T> myProvider;
    private boolean showDependencies = false;
    private final Map<DiagramNode, DiagramNoteNode> notes = new HashMap<DiagramNode, DiagramNoteNode>();
    private final Map<DiagramNoteNode, DiagramNoteEdge> noteEdges = new HashMap<DiagramNoteNode, DiagramNoteEdge>();
    private final DiagramScopeManager<T> myScopeManager;
    private boolean isInitState = true;
    public static Key<String> ORIGINAL_ELEMENT_FQN = Key.create((String)"ORIGINAL_ELEMENT_FQN");
    private final THashMap myUserData = new THashMap();

    public DiagramDataModel(Project project, DiagramProvider<T> provider) {
        this.myProject = project;
        this.myProvider = provider;
        this.myVisibilityManager = provider.createVisibilityManager();
        this.myScopeManager = provider.createScopeManager(project);
    }

    @NotNull
    public abstract Collection<? extends DiagramNode<T>> getNodes();

    @NotNull
    public abstract Collection<? extends DiagramEdge<T>> getEdges();

    @NotNull
    public DiagramNode<T> getSourceNode(DiagramEdge<T> e) {
        DiagramNode<T> diagramNode = e.getSource();
        if (diagramNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModel", "getSourceNode"));
        }
        return diagramNode;
    }

    @NotNull
    public DiagramNode<T> getTargetNode(DiagramEdge<T> e) {
        DiagramNode<T> diagramNode = e.getTarget();
        if (diagramNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModel", "getTargetNode"));
        }
        return diagramNode;
    }

    @NotNull
    public abstract String getNodeName(DiagramNode<T> var1);

    @NotNull
    public String getEdgeName(DiagramEdge<T> e) {
        String string = e.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramDataModel", "getEdgeName"));
        }
        return string;
    }

    @Nullable
    public DiagramEdge<T> createEdge(@NotNull DiagramNode<T> from, @NotNull DiagramNode<T> to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/diagram/DiagramDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/diagram/DiagramDataModel", "createEdge"));
        }
        return null;
    }

    public void removeEdge(DiagramEdge<T> edge) {
    }

    public <Type> Type getUserData(@NotNull Key<Type> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diagram/DiagramDataModel", "getUserData"));
        }
        return (Type)this.myUserData.get(key);
    }

    public <Type> void putUserData(@NotNull Key<Type> key, @Nullable Type value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diagram/DiagramDataModel", "putUserData"));
        }
        this.myUserData.put(key, value);
    }

    public DiagramVisibilityManager getVisibilityManager() {
        return this.myVisibilityManager;
    }

    public DiagramScopeManager<T> getScopeManager() {
        return this.myScopeManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    public DiagramProvider<T> getProvider() {
        return this.myProvider;
    }

    @Nullable
    public abstract DiagramNode<T> addElement(T var1);

    public void removeNode(DiagramNode<T> node) {
    }

    public boolean hasElement(T element) {
        return false;
    }

    public void collapseNode(DiagramNode<T> node) {
    }

    public void expandNode(DiagramNode<T> node) {
    }

    public abstract void refreshDataModel();

    @NotNull
    public abstract ModificationTracker getModificationTracker();

    public boolean isDependencyDiagramSupported() {
        return false;
    }

    public final void setShowDependencies(boolean show) {
        this.showDependencies = show;
    }

    public final boolean isShowDependencies() {
        return this.showDependencies;
    }

    public final Map<DiagramNode, DiagramNoteNode> getNotes() {
        return this.notes;
    }

    @Nullable
    public final DiagramNoteNode addNote(DiagramNode<T> node, String note) {
        if (note != null && note.length() > 0) {
            if (!this.notes.keySet().contains(node)) {
                DiagramNoteNode noteNode = new DiagramNoteNode(node, note);
                this.notes.put(node, noteNode);
                this.noteEdges.put(noteNode, new DiagramNoteEdge(node, noteNode));
                return noteNode;
            }
            DiagramNoteNode noteNode = this.notes.get(node);
            noteNode.setNote(note);
        }
        return null;
    }

    public final boolean isModelInitializationFinished() {
        return !this.isInitState;
    }

    public final void setModelInitializationFinished() {
        this.isInitState = false;
    }

    public final Collection<DiagramNoteEdge> getNoteEdges() {
        return this.noteEdges.values();
    }

    public final void removeNote(DiagramNoteNode note) {
        if (this.notes.values().contains(note)) {
            this.notes.remove(note.getIdentifyingElement());
            this.noteEdges.remove(note);
        }
    }

    public boolean isPsiListener() {
        return false;
    }

    public boolean hasFile(PsiFile file) {
        for (DiagramNode<T> node : this.getNodes()) {
            T element = node.getIdentifyingElement();
            if (!(element instanceof PsiElement) || !DiagramDataModel.containsRegardlessInjection(this.getProject(), file, (PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    public boolean hasReference(DocumentReference ref) {
        PsiFile psiFile;
        Document document = ref.getDocument();
        if (document != null && (psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document)) != null) {
            return this.hasFile(psiFile);
        }
        return false;
    }

    public void rebuild(T element) {
        this.removeAll();
    }

    private static boolean containsRegardlessInjection(Project project, PsiFile file, PsiElement element) {
        if (file == null) {
            return false;
        }
        if (element.getContainingFile() == file) {
            return true;
        }
        PsiLanguageInjectionHost host1 = InjectedLanguageManager.getInstance((Project)project).getInjectionHost(element);
        PsiLanguageInjectionHost host2 = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)file);
        if (host1 == null && host2 == null) {
            return false;
        }
        if (host1 != null && host2 != null) {
            return host1.getContainingFile() == host2.getContainingFile();
        }
        return host1 == null ? element.getContainingFile() == host2.getContainingFile() : host1.getContainingFile() == file;
    }

    public DiagramBuilder getBuilder() {
        DiagramBuilder builder = this.getUserData(Utils.GRAPH_BUILDER);
        assert (builder != null) : "Forget to set GraphBuilder";
        return builder;
    }

    public final void setupScopeManager(Object element, boolean showNotification) {
        DiagramScopeManager<T> scopeManager = this.getScopeManager();
        if (scopeManager != null && element instanceof PsiElement) {
            PackageSet value;
            PsiFile psiFile = ((PsiElement)element).getContainingFile();
            NamedScope currentScope = scopeManager.getCurrentScope();
            if (!(currentScope == null || (value = currentScope.getValue()) == null || psiFile != null && value.contains(psiFile, (NamedScopesHolder)NamedScopeManager.getInstance((Project)this.getProject())))) {
                scopeManager.setCurrentScope(CustomScopesProviderEx.getAllScope());
                if (showNotification) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DiagramAction.showNotification("Scope has been changed to <b>All</b>", DiagramDataModel.this.getBuilder());
                        }
                    });
                }
            }
        }
    }

    public final void removeAll() {
        for (DiagramNoteNode diagramNoteNode : new ArrayList<DiagramNoteNode>(this.getNotes().values())) {
            this.removeNote(diagramNoteNode);
        }
        for (DiagramNode<DiagramNode> diagramNode : new ArrayList<DiagramNode<T>>(this.getNodes())) {
            this.removeNode(diagramNode);
        }
    }

    public NodesGroup getGroup(DiagramNode<T> n) {
        return null;
    }
}

