/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.completion.SassScssCompletionContributor;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;
import org.jetbrains.plugins.scss.psi.stubs.SassScssMixinIndex;

public class MixinNamesProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/sass/completion/MixinNamesProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/MixinNamesProvider", "addCompletions"));
        }
        PsiFile originalFile = parameters.getOriginalFile();
        final PsiElement position = parameters.getPosition();
        Project project = parameters.getPosition().getProject();
        final String prefix = result.getPrefixMatcher().getPrefix();
        final Set importedFiles = CssUtil.getImportedFiles((PsiFile)originalFile, (PsiElement)position, (boolean)false);
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        for (String name : StubIndex.getInstance().getAllKeys(SassScssMixinIndex.KEY, project)) {
            SassScssMixinIndex.process(name, project, scope, (Processor<? super SassScssMixinDeclaration>)new Processor<SassScssMixinDeclaration>(){

                public boolean process(SassScssMixinDeclaration declaration) {
                    if (SASSSCSSLangUtil.isVisibleDeclaration((PsiElement)declaration, position)) {
                        boolean validResult = importedFiles.contains(declaration.getContainingFile().getVirtualFile());
                        result.addElement(SASSSCSSLangUtil.createMixinLookupItem(declaration, validResult, prefix));
                    }
                    return true;
                }
            });
        }
        result.restartCompletionOnPrefixChange(SassScssCompletionContributor.RESTART_IDENTIFIER_COMPLETION_CONDITION);
    }
}

