/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.scss.SCSSLanguage;

public class SassExtensionFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(final Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "getContexts"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "getContexts"));
            }
            return list;
        }
        LinkedList result = ContainerUtil.newLinkedList();
        for (SassExtension sassExtension : SassExtensionFileReferenceHelper.getAppropriateSassExtensions(project, file)) {
            result.addAll(sassExtension.getStylesheetsRoots(module));
        }
        VirtualFile parent = file.getParent();
        if (parent != null) {
            result.add(parent);
        }
        List list = ContainerUtil.skipNulls((Collection)ContainerUtil.map((Collection)result, (Function)new Function<VirtualFile, PsiFileSystemItem>(){

            public PsiFileSystemItem fun(VirtualFile file) {
                return SassExtensionFileReferenceHelper.this.getPsiFileSystemItem(project, file);
            }
        }));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "getContexts"));
        }
        return list;
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "isMine"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "isMine"));
        }
        if (!this.isMyFile(project, file)) {
            return false;
        }
        return SassExtensionFileReferenceHelper.getAppropriateSassExtensions(project, file).size() > 0;
    }

    @NotNull
    private static Collection<SassExtension> getAppropriateSassExtensions(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "getAppropriateSassExtensions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "getAppropriateSassExtensions"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            List<SassExtension> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "getAppropriateSassExtensions"));
            }
            return list;
        }
        Collection<SassExtension> collection = SassExtension.getAllExtensions(module);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "getAppropriateSassExtensions"));
        }
        return collection;
    }

    protected boolean isMyFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "isMyFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper", "isMyFile"));
        }
        String extension = file.getExtension();
        if ("sass".equalsIgnoreCase(extension) || "scss".equalsIgnoreCase(extension)) {
            return true;
        }
        PsiFileSystemItem item = this.getPsiFileSystemItem(project, file);
        if (item instanceof PsiFile) {
            Set allLanguages = ((PsiFile)item).getViewProvider().getLanguages();
            return allLanguages.contains((Object)SASSLanguage.INSTANCE) || allLanguages.contains((Object)SCSSLanguage.INSTANCE);
        }
        return true;
    }
}

