/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.highlighting;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.psi.css.CssBundle;
import icons.SassIcons;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.highlighting.SASSSyntaxHighlighter;
import org.jetbrains.plugins.sass.highlighting.SassScssHighlightingColors;

public class SASSColorsPage
implements ColorSettingsPage {
    private static final String DEMO_TEXT = "/* Some loud comment here */\n// And silent one\n\n$padding: 1% !default\n@import variables\n\n=large-text\n  :font\n    :family Arial\n    :size 20px\n    :weight bold\n  :color #ff0000\n\n#main a:visited span[lang=\"en\"]\n  @extend .shadow !optional\n  +large-text\n  p.info\n    color: #00ddcc\n  :width 97% !important\n\n@mixin with-shadow($color: black)\n  box-shadow: $color, 1px, 2px, 3px\n\n.shadowBlock\n  @include with-shadow(blue)\n\n$grid-width: 40px\n$gutter-width: 10px\n\n@function grid-width($n)\n$grid-width: 10px !global\n  @return $n * $grid-width + ($n - 1) * $gutter-width\n\n@for $i from 1 through 3\n  .item-#{$i} \n    width: 2em * $i\n\n@font-face\n  font-family: DroidSans\n  src: url(DroidSans.ttf)\n  unicode-range: U+000-5FF, U+1e00-1fff, U+2000-2300";
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(SASSBundle.message("color.settings.sass.variable"), SassScssHighlightingColors.VARIABLE), new AttributesDescriptor(SASSBundle.message("color.settings.sass.mixin"), SassScssHighlightingColors.MIXIN), new AttributesDescriptor(SASSBundle.message("color.settings.sass.interpolation"), SassScssHighlightingColors.INTERPOLATION), new AttributesDescriptor(SASSBundle.message("color.settings.sass.extend"), SassScssHighlightingColors.EXTEND), new AttributesDescriptor(SASSBundle.message("color.settings.sass.default"), SassScssHighlightingColors.DEFAULT), new AttributesDescriptor(SASSBundle.message("color.settings.sass.global"), SassScssHighlightingColors.GLOBAL), new AttributesDescriptor(SASSBundle.message("color.settings.sass.optional"), SassScssHighlightingColors.OPTIONAL), new AttributesDescriptor(CssBundle.message((String)"css.bad.character", (Object[])new Object[0]), SassScssHighlightingColors.BAD_CHARACTER), new AttributesDescriptor(CssBundle.message((String)"css.braces", (Object[])new Object[0]), SassScssHighlightingColors.BRACES), new AttributesDescriptor(CssBundle.message((String)"css.brackets", (Object[])new Object[0]), SassScssHighlightingColors.BRACKETS), new AttributesDescriptor(CssBundle.message((String)"css.colon", (Object[])new Object[0]), SassScssHighlightingColors.COLON), new AttributesDescriptor(CssBundle.message((String)"css.color", (Object[])new Object[0]), SassScssHighlightingColors.COLOR), new AttributesDescriptor(CssBundle.message((String)"css.comma", (Object[])new Object[0]), SassScssHighlightingColors.COMMA), new AttributesDescriptor(CssBundle.message((String)"css.comment", (Object[])new Object[0]), SassScssHighlightingColors.COMMENT), new AttributesDescriptor(CssBundle.message((String)"css.dot", (Object[])new Object[0]), SassScssHighlightingColors.DOT), new AttributesDescriptor(CssBundle.message((String)"css.function", (Object[])new Object[0]), SassScssHighlightingColors.FUNCTION), new AttributesDescriptor(CssBundle.message((String)"css.identifier", (Object[])new Object[0]), SassScssHighlightingColors.IDENTIFIER), new AttributesDescriptor(CssBundle.message((String)"css.id.selector", (Object[])new Object[0]), SassScssHighlightingColors.ID_SELECTOR), new AttributesDescriptor(CssBundle.message((String)"css.important", (Object[])new Object[0]), SassScssHighlightingColors.IMPORTANT), new AttributesDescriptor(CssBundle.message((String)"css.keyword", (Object[])new Object[0]), SassScssHighlightingColors.KEYWORD), new AttributesDescriptor(CssBundle.message((String)"css.number", (Object[])new Object[0]), SassScssHighlightingColors.NUMBER), new AttributesDescriptor(CssBundle.message((String)"css.operation.sign", (Object[])new Object[0]), SassScssHighlightingColors.OPERATORS), new AttributesDescriptor(CssBundle.message((String)"css.parenthesis", (Object[])new Object[0]), SassScssHighlightingColors.PARENTHESES), new AttributesDescriptor(CssBundle.message((String)"css.property.name", (Object[])new Object[0]), SassScssHighlightingColors.PROPERTY_NAME), new AttributesDescriptor(CssBundle.message((String)"css.property.value", (Object[])new Object[0]), SassScssHighlightingColors.PROPERTY_VALUE), new AttributesDescriptor(CssBundle.message((String)"css.pseudo.selector", (Object[])new Object[0]), SassScssHighlightingColors.PSEUDO), new AttributesDescriptor(CssBundle.message((String)"css.semicolon", (Object[])new Object[0]), SassScssHighlightingColors.SEMICOLON), new AttributesDescriptor(CssBundle.message((String)"css.string", (Object[])new Object[0]), SassScssHighlightingColors.STRING), new AttributesDescriptor(CssBundle.message((String)"css.tag.name", (Object[])new Object[0]), SassScssHighlightingColors.TAG_NAME), new AttributesDescriptor(CssBundle.message((String)"css.unicode.range", (Object[])new Object[0]), SassScssHighlightingColors.UNICODE_RANGE), new AttributesDescriptor(CssBundle.message((String)"css.url", (Object[])new Object[0]), SassScssHighlightingColors.URL)};
    private static final Map<String, TextAttributesKey> ADDITIONAL_HIGHLIGHT_DESCRIPTORS = new HashMap<String, TextAttributesKey>();
    private static final ColorDescriptor[] COLORS = new ColorDescriptor[0];

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ADDITIONAL_HIGHLIGHT_DESCRIPTORS;
    }

    @NotNull
    public String getDisplayName() {
        String string = SASSBundle.message("color.settings.sass.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/highlighting/SASSColorsPage", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SassIcons.Sass;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/highlighting/SASSColorsPage", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/highlighting/SASSColorsPage", "getAttributeDescriptors"));
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (COLORS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/highlighting/SASSColorsPage", "getColorDescriptors"));
        }
        return COLORS;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SASSSyntaxHighlighter sASSSyntaxHighlighter = new SASSSyntaxHighlighter();
        if (sASSSyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/highlighting/SASSColorsPage", "getHighlighter"));
        }
        return sASSSyntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if (DEMO_TEXT == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/highlighting/SASSColorsPage", "getDemoText"));
        }
        return DEMO_TEXT;
    }
}

