/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.index;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.stdlib.SassScssStubMarker;

public class SassScssIndexedRootProvider
extends IndexableSetContributor {
    private volatile Set<VirtualFile> myAdditionalRoots;

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        Set<VirtualFile> result = this.myAdditionalRoots;
        if (result == null || AdditionalIndexableFileSet.filesInvalidated(result)) {
            this.myAdditionalRoots = result = Collections.singleton(SassScssIndexedRootProvider.findStdlibStubFile());
        }
        Set<VirtualFile> set = result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/index/SassScssIndexedRootProvider", "getAdditionalRootsToIndex"));
        }
        return set;
    }

    public static SassScssIndexedRootProvider getInstance() {
        return (SassScssIndexedRootProvider)((Object)IndexableSetContributor.EP_NAME.findExtension(SassScssIndexedRootProvider.class));
    }

    private static VirtualFile findStdlibStubFile() {
        URL resource = SassScssStubMarker.class.getResource("sass_functions.scss");
        assert (resource != null);
        VirtualFile result = VfsUtil.findFileByURL((URL)resource);
        assert (result != null);
        return result;
    }
}

