/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.introduce;

import com.google.common.base.Strings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.psi.SASSFile;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;
import org.jetbrains.plugins.scss.introduce.SASSSCSSInplaceVariableIntroducer;
import org.jetbrains.plugins.scss.introduce.SCSSIntroduceDialog;
import org.jetbrains.plugins.scss.introduce.SassScssPlacingIntroduceVariableType;
import org.jetbrains.plugins.scss.introduce.SassScssPlacingVariableManager;
import org.jetbrains.plugins.scss.introduce.SassScssRefactoringPsiHelper;
import org.jetbrains.plugins.scss.psi.SASSSCSSElementVisitor;
import org.jetbrains.plugins.scss.psi.SCSSOperationImpl;
import org.jetbrains.plugins.scss.psi.SassScssBlock;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;

public abstract class SASSSCSSIntroduceHandlerBase
implements RefactoringActionHandler {
    public static final SassScssPlacingIntroduceVariableType DEFAULT_PLACING_TYPE = SassScssPlacingIntroduceVariableType.GLOBAL;
    private static final Logger LOG = Logger.getInstance(SASSSCSSIntroduceHandlerBase.class);
    @NonNls
    private static final String HELP_ID = "refactoring.extract.variable.sass";

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/scss/introduce/SASSSCSSIntroduceHandlerBase", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/plugins/scss/introduce/SASSSCSSIntroduceHandlerBase", "invoke"));
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/scss/introduce/SASSSCSSIntroduceHandlerBase", "invoke"));
        }
        this.performAction(project, editor, file, null, false, DEFAULT_PLACING_TYPE);
    }

    public void performAction(Project project, Editor editor, PsiFile file, @Nullable String name, boolean replaceAll, SassScssPlacingIntroduceVariableType placingType) {
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            this.smartIntroduce(project, file, editor, name, replaceAll, placingType);
            return;
        }
        Pair<PsiElement, PsiElement> selected = SassScssRefactoringPsiHelper.getSelectedElements(editor, file);
        PsiElement element1 = (PsiElement)selected.first;
        PsiElement element2 = (PsiElement)selected.second;
        if (element1 == null || element2 == null || element1.getTextOffset() > element2.getTextOffset()) {
            this.showErrorMessage(project, editor, RefactoringBundle.message((String)"introduce.selection.error"));
            return;
        }
        Object expression = SassScssRefactoringPsiHelper.getSelectedExpression(element1, element2);
        if (expression == null) {
            String message = RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression");
            this.showErrorMessage(project, editor, message);
            return;
        }
        this.performActionOnElement(project, editor, (PsiElement)expression, name, replaceAll, placingType);
    }

    protected void showErrorMessage(Project project, Editor editor, String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getTitle(), (String)HELP_ID);
    }

    protected void smartIntroduce(final Project project, PsiFile file, final Editor editor, final @Nullable String name, final boolean replaceAll, final SassScssPlacingIntroduceVariableType placingType) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = file.findElementAt(offset);
        elementAt = elementAt == null && offset > 0 ? file.findElementAt(offset - 1) : elementAt;
        ArrayList<PsiElement> expressions = new ArrayList<PsiElement>();
        for (elementAt = elementAt != null && (elementAt.getNode().getElementType() == SASSTokenTypes.EOL || elementAt.getNode().getElementType() == CssElementTypes.CSS_SEMICOLON || elementAt instanceof PsiWhiteSpace) ? PsiTreeUtil.prevLeaf((PsiElement)elementAt) : elementAt; elementAt != null && !(elementAt instanceof CssDeclaration) && !(elementAt instanceof CssRuleset); elementAt = elementAt.getParent()) {
            if (!SassScssRefactoringPsiHelper.checkCanExtract(elementAt)) continue;
            expressions.add(elementAt);
        }
        if (expressions.size() == 1) {
            this.performActionOnElement(project, editor, (PsiElement)expressions.get(0), name, replaceAll, placingType);
        } else if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<PsiElement>(){

                public void pass(PsiElement expression) {
                    SASSSCSSIntroduceHandlerBase.this.performActionOnElement(project, editor, expression, name, replaceAll, placingType);
                }
            }, (Function)new Function<PsiElement, String>(){

                public String fun(PsiElement expression) {
                    return expression.getText();
                }
            });
        } else {
            this.showErrorMessage(project, editor, RefactoringBundle.message((String)"introduce.selection.error"));
        }
    }

    protected void performActionOnElement(Project project, Editor editor, PsiElement expression, @Nullable String name, boolean replaceAll, SassScssPlacingIntroduceVariableType placingType) {
        SassScssStylesheetFile file = (SassScssStylesheetFile)expression.getContainingFile();
        List<PsiElement> occurrences = this.getOccurrences(expression, file);
        if (editor.getSettings().isVariableInplaceRenameEnabled()) {
            this.performInplaceIntroduce(project, editor, expression, file, occurrences);
        } else {
            Trinity<String, Boolean, SassScssPlacingIntroduceVariableType> nameAndReplaceChoice = this.getParametersForRefactoring(project, editor, file, expression, occurrences, name, replaceAll, placingType);
            String newName = (String)nameAndReplaceChoice.first;
            Boolean isReplaceAll = (Boolean)nameAndReplaceChoice.second;
            SassScssPlacingIntroduceVariableType replacingType = (SassScssPlacingIntroduceVariableType)((Object)nameAndReplaceChoice.third);
            if (newName == null && isReplaceAll == null) {
                return;
            }
            if (!SassScssPlacingVariableManager.variableExtractAvailable(replacingType, expression, isReplaceAll, occurrences)) {
                this.showErrorMessage(project, editor, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
                return;
            }
            this.performIntroduce(project, expression, newName, occurrences, isReplaceAll, replacingType);
        }
    }

    private void performInplaceIntroduce(final Project project, final Editor editor, final PsiElement expression, SassScssStylesheetFile file, final List<PsiElement> occurrences) {
        final List<String> names = SASSSCSSIntroduceHandlerBase.getSuggestedNames(expression, file);
        LOG.assertTrue(names.size() > 0, (Object)"Names suggested for variable is empty");
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)expression, occurrences, (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                final boolean replaceAll = choice == OccurrencesChooser.ReplaceChoice.ALL;
                ArrayList<PsiElement> exprList = new ArrayList<PsiElement>();
                exprList.add(expression);
                SASSSCSSIntroduceHandlerBase.showPlacingTypeChooser(editor, replaceAll ? occurrences : exprList, (Pass<SassScssPlacingIntroduceVariableType>)((Pass)new Pass<SassScssPlacingIntroduceVariableType>(){

                    public void pass(SassScssPlacingIntroduceVariableType type) {
                        if (!SassScssPlacingVariableManager.variableExtractAvailable(type, expression, replaceAll, occurrences)) {
                            SASSSCSSIntroduceHandlerBase.this.showErrorMessage(project, editor, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
                            return;
                        }
                        SassScssVariableDeclaration element = SASSSCSSIntroduceHandlerBase.this.performIntroduce(project, expression, Strings.nullToEmpty((String)((String)names.get(0))), occurrences, replaceAll, type);
                        PsiElement newExpression = element.getValue();
                        editor.getCaretModel().moveToOffset(element.getTextOffset());
                        SASSSCSSInplaceVariableIntroducer introducer = new SASSSCSSInplaceVariableIntroducer((PsiNamedElement)element, editor, project, occurrences, newExpression);
                        introducer.performInplaceRefactoring(new LinkedHashSet(names));
                    }
                }));
            }
        });
    }

    private static void showPlacingTypeChooser(Editor editor, List<PsiElement> occurrences, final Pass<SassScssPlacingIntroduceVariableType> callback) {
        DefaultListModel<SassScssPlacingIntroduceVariableType> model = new DefaultListModel<SassScssPlacingIntroduceVariableType>();
        for (SassScssPlacingIntroduceVariableType type : SassScssPlacingIntroduceVariableType.values()) {
            model.addElement(type);
        }
        JBList list = new JBList(model);
        final HashSet myRangeHighlighters = new HashSet();
        TextAttributes myAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        list.addListSelectionListener(new ListSelectionListener((JList)list, myRangeHighlighters, editor, occurrences, myAttributes){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Set val$myRangeHighlighters;
            final /* synthetic */ Editor val$editor;
            final /* synthetic */ List val$occurrences;
            final /* synthetic */ TextAttributes val$myAttributes;
            {
                this.val$list = jList;
                this.val$myRangeHighlighters = set;
                this.val$editor = editor;
                this.val$occurrences = list;
                this.val$myAttributes = textAttributes;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SassScssPlacingIntroduceVariableType value = (SassScssPlacingIntroduceVariableType)((Object)this.val$list.getSelectedValue());
                if (value == null) {
                    return;
                }
                for (RangeHighlighter highlight : this.val$myRangeHighlighters) {
                    highlight.dispose();
                }
                this.val$myRangeHighlighters.clear();
                MarkupModel markupModel = this.val$editor.getMarkupModel();
                for (PsiElement occurrence : this.val$occurrences) {
                    TextRange textRange = occurrence.getTextRange();
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, this.val$myAttributes, HighlighterTargetArea.EXACT_RANGE);
                    this.val$myRangeHighlighters.add(rangeHighlighter);
                }
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Place for declaration").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void run() {
                callback.pass((Object)((SassScssPlacingIntroduceVariableType)((Object)this.val$list.getSelectedValue())));
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                for (RangeHighlighter highlight : myRangeHighlighters) {
                    highlight.dispose();
                }
                myRangeHighlighters.clear();
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    protected Trinity<String, Boolean, SassScssPlacingIntroduceVariableType> getParametersForRefactoring(Project project, Editor editor, SassScssStylesheetFile file, PsiElement element, List<PsiElement> occurrences, @Nullable String name, boolean replaceAll, SassScssPlacingIntroduceVariableType placingType) {
        if (name == null) {
            List<String> names = SASSSCSSIntroduceHandlerBase.getSuggestedNames(element, file);
            SCSSIntroduceDialog dialog = new SCSSIntroduceDialog(project, this.getTitle(), HELP_ID, occurrences.size(), names, file.getVariableDeclarations().keySet(), placingType);
            if (!dialog.showAndGet()) {
                return Trinity.create(null, null, (Object)((Object)placingType));
            }
            name = dialog.getName();
            replaceAll = dialog.doReplaceAllOccurrences();
            placingType = dialog.getPlacingType();
        } else {
            Collection declarations = file.getVariableDeclarations().get((Object)(StringUtil.startsWithChar((CharSequence)name, (char)'$') ? name.substring(1) : name));
            CssBlock block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class);
            boolean nameAvailable = true;
            if (placingType == SassScssPlacingIntroduceVariableType.LOCAL) {
                for (SassScssVariableDeclaration declaration : declarations) {
                    if (declaration.isGlobal() || !PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)declaration, (boolean)false)) continue;
                    nameAvailable = false;
                }
            } else if (!declarations.isEmpty()) {
                nameAvailable = false;
            }
            if (!nameAvailable) {
                this.showErrorMessage(project, editor, RefactoringBundle.message((String)"refactoring.introduce.variable.scope.error"));
                return Trinity.create(null, null, (Object)((Object)placingType));
            }
        }
        return Trinity.create((Object)name, (Object)replaceAll, (Object)((Object)placingType));
    }

    @NotNull
    private SassScssVariableDeclaration performIntroduce(final Project project, final PsiElement expression, final String name, final List<PsiElement> occurrences, final boolean replaceAll, final SassScssPlacingIntroduceVariableType placingType) {
        final Ref result = new Ref();
        final SassScssVariableDeclaration declaration = this.createDeclaration(project, expression, name);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(new Runnable(){

                    @Override
                    public void run() {
                        AccessToken token = WriteAction.start();
                        try {
                            result.set((Object)SASSSCSSIntroduceHandlerBase.this.performReplace(project, declaration, expression, name, occurrences, replaceAll, placingType));
                        }
                        finally {
                            token.finish();
                        }
                    }
                });
            }
        }, this.getTitle(), null);
        PsiElement element = (PsiElement)result.get();
        LOG.assertTrue(element instanceof SassScssVariableDeclaration, (Object)"Extracted variable declaration is not SCSSVariable");
        SassScssVariableDeclaration sassScssVariableDeclaration = (SassScssVariableDeclaration)element;
        if (sassScssVariableDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/introduce/SASSSCSSIntroduceHandlerBase", "performIntroduce"));
        }
        return sassScssVariableDeclaration;
    }

    @Nullable
    protected PsiElement performReplace(Project project, SassScssVariableDeclaration declaration, PsiElement expression, String name, List<PsiElement> occurrences, boolean replaceAll, SassScssPlacingIntroduceVariableType placingType) {
        PsiElement result = SASSSCSSIntroduceHandlerBase.insertDeclaration(declaration, expression, placingType);
        if (replaceAll) {
            for (PsiElement occurrence : occurrences) {
                this.replaceExpressionWithText(project, occurrence, name);
            }
        } else {
            this.replaceExpressionWithText(project, expression, name);
        }
        return result;
    }

    @Nullable
    public static PsiElement insertDeclaration(SassScssVariableDeclaration declaration, PsiElement expression, @Nullable SassScssPlacingIntroduceVariableType placingType) {
        if (placingType == null) {
            placingType = SassScssPlacingIntroduceVariableType.GLOBAL;
        }
        Pair<PsiElement, Boolean> insertSettings = SassScssPlacingVariableManager.getPlaceForDeclaration(placingType, expression);
        return SASSSCSSIntroduceHandlerBase.insertDeclaration(insertSettings, declaration);
    }

    private static List<String> getSuggestedNames(PsiElement expression, SassScssStylesheetFile file) {
        CssDeclaration cssDeclaration;
        ArrayList<String> list = new ArrayList<String>();
        Set variableNames = file.getVariableDeclarations().keySet();
        if (expression instanceof CssTerm) {
            list.add(SASSSCSSIntroduceHandlerBase.getAvailableName(((CssTerm)expression).getTermType().toString().toLowerCase(Locale.US), variableNames));
        }
        if (expression instanceof CssTermList) {
            list.add(SASSSCSSIntroduceHandlerBase.getAvailableName("list", variableNames));
        }
        if ((cssDeclaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression, CssDeclaration.class)) != null) {
            list.add(SASSSCSSIntroduceHandlerBase.getAvailableName(cssDeclaration.getPropertyName(), variableNames));
        }
        list.add(SASSSCSSIntroduceHandlerBase.getAvailableName("var", variableNames));
        return list;
    }

    private static String getAvailableName(String name, Set<String> variableNames) {
        String finalName = name;
        int i = 1;
        while (variableNames.contains(finalName)) {
            finalName = name.concat(String.valueOf(i++));
        }
        return finalName;
    }

    @Nullable
    protected static PsiElement insertDeclaration(Pair<PsiElement, Boolean> insertSettings, SassScssVariableDeclaration declaration) {
        PsiElement result;
        if (insertSettings == null) {
            return null;
        }
        PsiElement anchor = (PsiElement)insertSettings.getFirst();
        if (anchor == null) {
            return null;
        }
        boolean insertBefore = (Boolean)insertSettings.getSecond();
        PsiElement lineFeed = CodeEditUtil.createLineFeed((PsiManager)anchor.getManager());
        PsiElement parent = anchor.getParent();
        if (insertBefore) {
            if (anchor instanceof CssBlock || anchor instanceof SassScssBlock || anchor instanceof PsiFile) {
                parent = anchor;
                PsiElement blockFirstChild = PsiTreeUtil.getChildOfAnyType((PsiElement)anchor, (Class[])new Class[]{CssElement.class});
                result = blockFirstChild != null ? anchor.addBefore((PsiElement)declaration, blockFirstChild) : anchor.add((PsiElement)declaration);
            } else {
                result = parent.addBefore((PsiElement)declaration, anchor);
            }
            if (lineFeed != null) {
                PsiElement semicolon = Factory.createSingleLeafElement((IElementType)CssElementTypes.CSS_SEMICOLON, (CharSequence)";", (int)0, (int)1, null, (PsiManager)anchor.getManager()).getPsi();
                parent.addAfter(lineFeed, anchor.getContainingFile() instanceof SASSFile ? result : parent.addAfter(semicolon, result));
            }
        } else {
            boolean sass = anchor.getContainingFile() instanceof SASSFile;
            PsiElement next = anchor.getNextSibling();
            result = parent.addAfter((PsiElement)declaration, sass ? anchor : next);
            if (!sass && next != null) {
                parent.addAfter(next, result);
            }
        }
        return result;
    }

    @NotNull
    public List<PsiElement> getOccurrences(final @NotNull PsiElement pattern, @Nullable SassScssStylesheetFile context) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/plugins/scss/introduce/SASSSCSSIntroduceHandlerBase", "getOccurrences"));
        }
        if (context == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/introduce/SASSSCSSIntroduceHandlerBase", "getOccurrences"));
            }
            return list;
        }
        final ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        CssElementVisitor visitor = null;
        if (pattern instanceof SCSSOperationImpl) {
            visitor = new SASSSCSSElementVisitor(){

                @Override
                public void visitSCSSOperation(SCSSOperationImpl operation) {
                    if (PsiTreeUtil.getParentOfType((PsiElement)operation, SassScssVariableDeclaration.class) != null) {
                        return;
                    }
                    if (operation.getText().equals(pattern.getText())) {
                        occurrences.add(operation);
                        return;
                    }
                    operation.acceptChildren((PsiElementVisitor)this);
                }

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/introduce/SASSSCSSIntroduceHandlerBase$8", "visitElement"));
                    }
                    element.acceptChildren((PsiElementVisitor)this);
                }
            };
        } else if (pattern instanceof CssTerm || pattern instanceof CssTermList) {
            visitor = new CssElementVisitor(){

                public void visitCssTermList(CssTermList termList) {
                    if (PsiTreeUtil.getParentOfType((PsiElement)termList, SassScssVariableDeclaration.class) != null) {
                        return;
                    }
                    if (!(pattern instanceof CssTermList)) {
                        termList.acceptChildren((PsiElementVisitor)this);
                        return;
                    }
                    if (termList.getText().equals(pattern.getText())) {
                        occurrences.add(termList);
                        return;
                    }
                    termList.acceptChildren((PsiElementVisitor)this);
                }

                public void visitCssTerm(CssTerm term) {
                    SassScssVariableDeclaration declaration = (SassScssVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)term, SassScssVariableDeclaration.class);
                    if (!(pattern instanceof CssTerm) || declaration != null) {
                        return;
                    }
                    if (term.getText().equals(pattern.getText())) {
                        occurrences.add(term);
                        return;
                    }
                    term.acceptChildren((PsiElementVisitor)this);
                }

                public void visitCssFunction(CssFunction function) {
                    for (PsiElement element : function.getChildren()) {
                        if (!element.getText().equals(pattern.getText())) continue;
                        occurrences.add(element);
                    }
                    function.acceptChildren((PsiElementVisitor)this);
                }

                public void visitElement(PsiElement element) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            };
        }
        if (visitor != null) {
            context.acceptChildren((PsiElementVisitor)visitor);
        }
        ArrayList<PsiElement> arrayList = occurrences;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/introduce/SASSSCSSIntroduceHandlerBase", "getOccurrences"));
        }
        return arrayList;
    }

    protected abstract PsiElement replaceExpressionWithText(Project var1, PsiElement var2, String var3);

    protected abstract SassScssVariableDeclaration createDeclaration(Project var1, PsiElement var2, String var3);

    protected abstract String getTitle();
}

