/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.references;

import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.psi.stubs.ScssFunctionsIndex;

public class SassScssFunctionReference
extends PsiPolyVariantReferenceBase<CssFunction> {
    public SassScssFunctionReference(CssFunction element) {
        super((PsiElement)element);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (!(((CssFunction)this.myElement).getContainingFile() instanceof SassScssStylesheetFile)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssFunctionReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String functionName = ((CssFunction)this.myElement).getName();
        ResolveResult[] resolveResultArray = SassScssFunctionReference.resolveByName(functionName, this.myElement, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssFunctionReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    public static ResolveResult[] resolveByName(@NotNull String functionName, final @NotNull PsiElement context, boolean incompleteCode) {
        ResolveResult singleResult;
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/plugins/scss/references/SassScssFunctionReference", "resolveByName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/scss/references/SassScssFunctionReference", "resolveByName"));
        }
        final Set importedFiles = CssUtil.getImportedFiles((PsiFile)context.getContainingFile(), (PsiElement)context, (boolean)false);
        final LinkedList resultResolvedWithImports = Lists.newLinkedList();
        final LinkedList resultResolvedByNameOnly = Lists.newLinkedList();
        GlobalSearchScope scope = SASSSCSSLangUtil.searchScopeWithSassStdlib(context);
        ScssFunctionsIndex.process(functionName, context.getProject(), scope, (Processor<? super SassScssFunctionDeclaration>)new Processor<SassScssFunctionDeclaration>(){

            public boolean process(SassScssFunctionDeclaration declaration) {
                if (SASSSCSSLangUtil.isVisibleDeclaration((PsiElement)declaration, context)) {
                    boolean validResult = importedFiles.contains(declaration.getContainingFile().getVirtualFile());
                    PsiElementResolveResult resolveResult = new PsiElementResolveResult((PsiElement)declaration, validResult);
                    if (validResult) {
                        resultResolvedWithImports.add(resolveResult);
                    } else {
                        resultResolvedByNameOnly.add(resolveResult);
                    }
                }
                return true;
            }
        });
        LinkedList result = resultResolvedWithImports;
        if (result.isEmpty()) {
            result = resultResolvedByNameOnly;
        } else if (!incompleteCode && result.size() > 1 && (singleResult = SASSSCSSLangUtil.filterOverridedResults(result, context)) != null) {
            return new ResolveResult[]{singleResult};
        }
        if (result.isEmpty()) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            Collection<SassExtensionFunctionInfo> functions = SassExtension.findExtensionFunctionInfos(functionName, context, module);
            Set psiFunctions = ContainerUtil.set((Object[])new PsiElement[0]);
            for (SassExtensionFunctionInfo function : functions) {
                PsiElement declaration = function.getFunctionDeclaration();
                if (declaration == null) continue;
                psiFunctions.add(declaration);
            }
            if (!psiFunctions.isEmpty()) {
                return PsiElementResolveResult.createResults((Collection)psiFunctions);
            }
            if (!functions.isEmpty()) {
                return new ResolveResult[]{new PsiElementResolveResult(context)};
            }
        }
        return result.toArray(new ResolveResult[result.size()]);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssFunctionReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

