/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.references;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.impl.CssFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSFileType;
import org.jetbrains.plugins.scss.SCSSFileType;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.references.SassScssImportReference;

public class SassScssImportReferenceSet
extends FileReferenceSet {
    @NotNull
    private final PsiElement myRefContainingFile;
    private final Condition<PsiFileSystemItem> COMPLETION_FILTER;

    public SassScssImportReferenceSet(@NotNull CssString uriString, @NotNull PsiReferenceProvider provider) {
        if (uriString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uriString", "org/jetbrains/plugins/scss/references/SassScssImportReferenceSet", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/plugins/scss/references/SassScssImportReferenceSet", "<init>"));
        }
        super(StringUtil.stripQuotesAroundValue((String)uriString.getText()), (PsiElement)uriString, SassScssImportReferenceSet.offset(uriString.getText()), provider, SystemInfo.isFileSystemCaseSensitive, true, new FileType[]{CssFileType.INSTANCE, SASSFileType.SASS, SCSSFileType.SCSS});
        this.COMPLETION_FILTER = new Condition<PsiFileSystemItem>(){

            public boolean value(PsiFileSystemItem item) {
                return SassScssImportReferenceSet.this.myRefContainingFile != item && (item.isDirectory() || item instanceof CssFileImpl || item instanceof SassScssStylesheetFile);
            }
        };
        this.myRefContainingFile = uriString.getContainingFile().getOriginalFile();
    }

    private static int offset(String text) {
        return text.length() > 0 && (text.charAt(0) == '\'' || text.charAt(0) == '\"') ? 1 : 0;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new SassScssImportReference(this, range, index, text);
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return this.COMPLETION_FILTER;
    }
}

