/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.references;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.references.SassScssFunctionReference;
import org.jetbrains.plugins.scss.references.SassScssImportReferenceSet;
import org.jetbrains.plugins.scss.references.SassScssSimpleSelectorReference;

public class SassScssReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<PsiElement> PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new SassScssReferencePattern());

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(PATTERN, (PsiReferenceProvider)new SassScssReferenceProvider(), 100.0);
    }

    private static class SassScssReferencePattern
    extends PatternCondition<PsiElement> {
        public SassScssReferencePattern() {
            super("sass/scss reference");
        }

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor$SassScssReferencePattern", "accepts"));
            }
            Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)element);
            if (language != SASSLanguage.INSTANCE && language != SCSSLanguage.INSTANCE) {
                return false;
            }
            return element instanceof CssFunction || element.getNode().getElementType() == CssElementTypes.CSS_IDENT || CssReferenceProvider.isStringOrUrl((PsiElement)element);
        }
    }

    private static class SassScssReferenceProvider
    extends PsiReferenceProvider {
        private SassScssReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor$SassScssReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor$SassScssReferenceProvider", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)element, (CachedValueProvider)new CachedValueProvider<PsiReference[]>(){

                @Nullable
                public CachedValueProvider.Result<PsiReference[]> compute() {
                    return CachedValueProvider.Result.create((Object)SassScssReferenceProvider.this.getReferences(element), (Object[])new Object[]{element});
                }
            });
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor$SassScssReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }

        @NotNull
        private PsiReference[] getReferences(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor$SassScssReferenceProvider", "getReferences"));
            }
            if (CssReferenceProvider.isImport((PsiElement)element) && !CssReferenceProvider.isUrlLink((PsiElement)element) && element instanceof CssString) {
                FileReference[] fileReferenceArray = new SassScssImportReferenceSet((CssString)element, this).getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor$SassScssReferenceProvider", "getReferences"));
                }
                return fileReferenceArray;
            }
            if (element instanceof CssFunction) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new SassScssFunctionReference((CssFunction)element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor$SassScssReferenceProvider", "getReferences"));
                }
                return psiReferenceArray;
            }
            if (element.getNode().getElementType() == CssElementTypes.CSS_IDENT && (parent = element.getParent()) instanceof CssSimpleSelector) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new SassScssSimpleSelectorReference(element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor$SassScssReferenceProvider", "getReferences"));
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssReferenceContributor$SassScssReferenceProvider", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
    }
}

