/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.actions;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.Properties;

public class GuiceBindingAnnotationBuilder {
    private final Project myProject;
    private String className = null;

    public GuiceBindingAnnotationBuilder(Project project) {
        this.myProject = project;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String buildAnnotationClass() throws IOException {
        FileTemplate headerTemplate;
        StringBuilder out = new StringBuilder(1024);
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)this.myProject);
        try {
            headerTemplate = templateManager.getInternalTemplate("File Header");
        }
        catch (Exception e) {
            headerTemplate = null;
        }
        Properties defaultProperties = templateManager.getDefaultProperties();
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("PACKAGE_NAME", "www.bullshit.com");
        properties.setProperty("NAME", this.className);
        if (headerTemplate != null) {
            String headerText = headerTemplate.getText(properties);
            String cleanedText = headerText.replace("public file header " + this.className + " { }", "");
            out.append(cleanedText);
        }
        out.append('\n');
        out.append("@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\n");
        out.append("@java.lang.annotation.Target({java.lang.annotation.ElementType.TYPE, java.lang.annotation.ElementType.PARAMETER})\n");
        out.append("@com.google.inject.BindingAnnotation\n");
        out.append("public @interface " + this.className + " {}\n");
        return out.toString();
    }
}

