/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.actions;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.actions.GeneratePluginClassAction;
import com.intellij.guice.actions.GuiceBindingAnnotationBuilder;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NewGuiceBindingAnnotationAction
extends GeneratePluginClassAction {
    private static final Logger LOGGER = Logger.getInstance((String)"NewGuiceBindingAnnotationAction");

    public NewGuiceBindingAnnotationAction() {
        super(GuiceBundle.message("new.guice.binding.annotation.action.name", new Object[0]), GuiceBundle.message("new.guice.binding.annotation.action.name", new Object[0]), null);
    }

    @Override
    protected PsiElement[] invokeDialogImpl(Project project, PsiDirectory directory) {
        String annotationName = Messages.showInputDialog((String)"Name for new binding annotation", (String)"Create Guice Binding Annotation", (Icon)Messages.getQuestionIcon());
        if (annotationName != null) {
            CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
            validator.canClose(annotationName);
            return validator.getCreatedElements();
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) {
        PsiElement[] psiElementArray;
        block6: {
            String beanClassString;
            Project project = directory.getProject();
            PsiFileFactory elementFactory = PsiFileFactory.getInstance((Project)project);
            GuiceBindingAnnotationBuilder builder = new GuiceBindingAnnotationBuilder(project);
            builder.setClassName(newName);
            try {
                beanClassString = builder.buildAnnotationClass();
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/actions/NewGuiceBindingAnnotationAction", "create"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            try {
                PsiFile newFile = elementFactory.createFileFromText(newName + ".java", beanClassString);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                PsiElement shortenedFile = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)newFile);
                PsiElement reformattedFile = codeStyleManager.reformat(shortenedFile);
                directory.add(reformattedFile);
                psiElementArray = new PsiElement[]{reformattedFile};
                if (psiElementArray != null) break block6;
            }
            catch (IncorrectOperationException e) {
                LOGGER.error((Throwable)e);
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/actions/NewGuiceBindingAnnotationAction", "create"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/actions/NewGuiceBindingAnnotationAction", "create"));
        }
        return psiElementArray;
    }

    protected String getErrorTitle() {
        return GuiceBundle.message("new.guice.binding.annotation.error", new Object[0]);
    }

    protected String getCommandName() {
        return GuiceBundle.message("new.guice.binding.annotation.command", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return GuiceBundle.message("new.guice.binding.annotation.name", directory, newName);
    }
}

