/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.reference;

import com.intellij.guice.utils.MutationUtils;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NamedReference
implements PsiPolyVariantReference {
    private final PsiLiteralExpression element;

    NamedReference(PsiLiteralExpression element) {
        this.element = element;
    }

    public PsiElement getElement() {
        return this.element;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.element.getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        return null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String text = this.element.getText();
        String strippedText = text.substring(1, text.length() - 1);
        List properties = PropertiesUtil.findAllProperties((Project)this.element.getProject(), null, (String)strippedText);
        HashSet propertySet = new HashSet(properties);
        ResolveResult[] out = new ResolveResult[propertySet.size()];
        int i = 0;
        for (IProperty property : propertySet) {
            out[i] = new CandidateInfo(property.getPsiElement(), PsiSubstitutor.EMPTY);
            ++i;
        }
        if (out == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/reference/NamedReference", "multiResolve"));
        }
        return out;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.element.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/reference/NamedReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return MutationUtils.replaceExpression('\"' + newElementName + '\"', (PsiExpression)this.element);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/guice/reference/NamedReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element == null) {
            return false;
        }
        if (!(element instanceof PsiField)) {
            return false;
        }
        return element.equals(this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        List properties = PropertiesUtil.findAllProperties((Project)this.element.getProject(), null, null);
        ArrayList<String> out = new ArrayList<String>();
        for (IProperty property : properties) {
            out.add(property.getName());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(out);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/reference/NamedReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }
}

