/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.javaee.cloudfoundry.agent.CFAppFogInfra;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFServerConfiguration;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import java.util.HashMap;
import java.util.Map;

public abstract class CFCloudLocation {
    public static final CloudDeploymentNameProvider NAME_PROVIDER = CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER;
    public static final CFCloudLocation GLOBAL = new CFCloudLocation("GLOBAL", "Global"){

        @Override
        public String getApiUrl(CFServerConfiguration serverConfig) {
            return serverConfig.getApiUrl();
        }

        @Override
        public String getAppUrl(CFServerConfiguration serverConfig, DeploymentTask<CFDeploymentConfiguration> deploymentTask) {
            CFAppFogInfra infra;
            CFDeploymentConfiguration deploymentConfig;
            CFDeploymentConfiguration cFDeploymentConfiguration = deploymentConfig = deploymentTask == null ? null : (CFDeploymentConfiguration)deploymentTask.getConfiguration();
            if (deploymentConfig != null && !deploymentConfig.isDefaultDomain()) {
                return CFCloudLocation.createUrl(null, deploymentConfig.getDomain());
            }
            if (serverConfig.isAppFog() && deploymentConfig != null && (infra = deploymentConfig.getAppFogInfra()) != null) {
                return CFCloudLocation.createDefaultAppUrl((DeploymentTask<CFDeploymentConfiguration>)deploymentTask, infra.getDomain());
            }
            String defaultDomain = serverConfig.getDefaultDomain();
            if (defaultDomain != null) {
                return CFCloudLocation.createDefaultAppUrl((DeploymentTask<CFDeploymentConfiguration>)deploymentTask, defaultDomain);
            }
            if (deploymentConfig != null) {
                return CFCloudLocation.createUrl(null, deploymentConfig.getDomain());
            }
            return CFCloudLocation.createUrl(null, "cloudfoundry.com");
        }
    };
    public static final CFCloudLocation LOCAL = new LocalInstanceBase("LOCAL", "Local (vcap.me)"){

        @Override
        protected String getDomain(CFServerConfiguration serverConfig) {
            return "vcap.me";
        }
    };
    public static final CFCloudLocation MICRO_OFFLINE = new LocalInstanceBase("MICRO_OFFLINE", "Micro - offline"){

        @Override
        protected String getDomain(CFServerConfiguration serverConfig) {
            return serverConfig.getDomain();
        }

        @Override
        public String getApiUrl(CFServerConfiguration serverConfig) {
            return this.appendPort(super.getApiUrl(serverConfig), serverConfig);
        }

        @Override
        public String getAppUrl(CFServerConfiguration serverConfig, DeploymentTask<CFDeploymentConfiguration> deploymentTask) {
            return this.appendPort(super.getAppUrl(serverConfig, deploymentTask), serverConfig);
        }

        private String appendPort(String url, CFServerConfiguration serverConfig) {
            return url + ":" + serverConfig.getPort();
        }
    };
    public static final CFCloudLocation[] LOCATIONS = new CFCloudLocation[]{GLOBAL, LOCAL, MICRO_OFFLINE};
    private static final Map<String, CFCloudLocation> ourId2Locations = new HashMap<String, CFCloudLocation>();
    private final String myId;
    private final String myName;

    private static String createDefaultAppUrl(DeploymentTask<CFDeploymentConfiguration> deploymentTask, String domain) {
        DeploymentSource deploymentSource = deploymentTask == null ? null : deploymentTask.getSource();
        String subDomain = deploymentSource == null ? null : NAME_PROVIDER.getDeploymentName(deploymentSource);
        return CFCloudLocation.createUrl(subDomain, domain);
    }

    public static CFCloudLocation get(String id) {
        CFCloudLocation location = ourId2Locations.get(id);
        return location == null ? GLOBAL : location;
    }

    private CFCloudLocation(String id, String name) {
        this.myId = id;
        this.myName = name;
    }

    public String getId() {
        return this.myId;
    }

    public String toString() {
        return this.myName;
    }

    private static String createUrl(String subDomain, String domain) {
        StringBuilder result = new StringBuilder();
        result.append("http://");
        if (subDomain != null) {
            result.append(subDomain);
            result.append(".");
        }
        result.append(StringUtil.isEmpty((String)domain) ? "<>" : domain);
        return result.toString();
    }

    public abstract String getApiUrl(CFServerConfiguration var1);

    public abstract String getAppUrl(CFServerConfiguration var1, DeploymentTask<CFDeploymentConfiguration> var2);

    static {
        for (CFCloudLocation location : LOCATIONS) {
            ourId2Locations.put(location.getId(), location);
        }
    }

    private static abstract class LocalInstanceBase
    extends CFCloudLocation {
        private LocalInstanceBase(String id, String name) {
            super(id, name);
        }

        @Override
        public String getApiUrl(CFServerConfiguration serverConfig) {
            return CFCloudLocation.createUrl("api", this.getDomain(serverConfig));
        }

        @Override
        public String getAppUrl(CFServerConfiguration serverConfig, DeploymentTask<CFDeploymentConfiguration> deploymentTask) {
            return CFCloudLocation.createDefaultAppUrl((DeploymentTask<CFDeploymentConfiguration>)deploymentTask, this.getDomain(serverConfig));
        }

        protected abstract String getDomain(CFServerConfiguration var1);
    }
}

