/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgent;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServices;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettings;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.remoteServer.agent.util.CloudAgentApplication;
import com.intellij.remoteServer.agent.util.CloudAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudAgentDeploymentCallback;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.CloudApplicationRuntimeBase;
import com.intellij.remoteServer.util.CloudLoggingHandlerImpl;
import java.io.File;

public class CFDeploymentRuntime
extends CloudApplicationRuntimeBase {
    private final LoggingHandler myMainLoggingHandler;
    private final String myAppUrl;
    private final DeploymentLogManager myLogManager;
    private final CloudAgentDeployment myDeployment;

    public CFDeploymentRuntime(ServerTaskExecutor tasksExecutor, CFCloudAgent agent, final String deploymentName, String appUrl, DeploymentTask<CFDeploymentConfiguration> task, DeploymentLogManager logManager) {
        super(tasksExecutor, deploymentName);
        this.myAppUrl = appUrl;
        this.myLogManager = logManager;
        this.myMainLoggingHandler = logManager.getMainLoggingHandler();
        final DeploymentSource source = task.getSource();
        final CFDeploymentConfiguration configuration = (CFDeploymentConfiguration)task.getConfiguration();
        this.myDeployment = agent.createDeployment(new CFCloudAgentDeploymentConfiguration(){

            public String getDeploymentName() {
                return deploymentName;
            }

            public File getFile() {
                return source.getFile();
            }

            @Override
            public CFAppSettings getApplicationSettings() {
                return configuration.getApplicationSettings();
            }

            @Override
            public CFAppServices getApplicationServices() {
                return configuration.getApplicationServices();
            }

            @Override
            public String getAppUrl() {
                return CFDeploymentRuntime.this.myAppUrl;
            }

            @Override
            public String getAppType() {
                return configuration.getType().getAppType();
            }

            @Override
            public String getInfra() {
                return configuration.getInfra();
            }
        }, (CloudAgentLoggingHandler)new CloudLoggingHandlerImpl(this.myLogManager));
    }

    protected CloudAgentApplication getApplication() {
        return this.myDeployment;
    }

    public void deploy(final ServerRuntimeInstance.DeploymentOperationCallback callback) {
        this.myDeployment.deploy(new CloudAgentDeploymentCallback(){

            public void succeeded() {
                CFDeploymentRuntime.this.myMainLoggingHandler.print("Application is available at ");
                CFDeploymentRuntime.this.myMainLoggingHandler.printHyperlink(CFDeploymentRuntime.this.myAppUrl);
                CFDeploymentRuntime.this.myMainLoggingHandler.print("\n");
                callback.succeeded((DeploymentRuntime)CFDeploymentRuntime.this);
            }

            public void errorOccurred(String errorMessage) {
                callback.errorOccurred(errorMessage);
            }
        });
    }
}

