/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.javaee.cloudfoundry.CFProvider;
import com.intellij.javaee.cloudfoundry.CFVersion;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFCloudLocation;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.xmlb.annotations.Transient;

public class CFServerConfiguration
extends CloudConfigurationBase<CFServerConfiguration>
implements CFCloudAgentConfiguration {
    public static final int DEFAULT_PORT = 80;
    private String myLocationId = CFCloudLocation.GLOBAL.getId();
    private String myApiUrl;
    private String myOrganization;
    private String mySpace;
    private String myVersion;
    private String myDomain;
    private boolean myTrustSelfSignedCert;
    private int myPort = 80;

    public CFVersion getVersion() {
        for (CFVersion version : CFVersion.values()) {
            if (!version.getId().equals(this.myVersion)) continue;
            return version;
        }
        return CFVersion.V2;
    }

    public void setVersion(CFVersion version) {
        this.myVersion = version.getId();
    }

    public String getLocationId() {
        return this.myLocationId;
    }

    public void setLocationId(String locationId) {
        this.myLocationId = locationId;
    }

    public String getApiUrl() {
        return this.myApiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.myApiUrl = apiUrl;
    }

    @Override
    public String getOrganization() {
        return this.myOrganization;
    }

    public void setOrganization(String organization) {
        this.myOrganization = organization;
    }

    @Override
    public String getSpace() {
        return this.mySpace;
    }

    public void setSpace(String space) {
        this.mySpace = space;
    }

    public void setDomain(String domain) {
        this.myDomain = domain;
    }

    public String getDomain() {
        return this.myDomain;
    }

    @Override
    public boolean isTrustSelfSignedCert() {
        return this.myTrustSelfSignedCert;
    }

    public void setTrustSelfSignedCert(boolean trustSelfSignedCert) {
        this.myTrustSelfSignedCert = trustSelfSignedCert;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public Integer getPort() {
        return this.myPort;
    }

    @Transient
    public CFProvider getProvider() {
        for (CFProvider provider : CFProvider.values()) {
            if (!provider.getApiUrl().equals(this.myApiUrl)) continue;
            return provider;
        }
        return null;
    }

    @Transient
    public String getDefaultDomain() {
        CFProvider provider = this.getProvider();
        return provider == null ? null : provider.getDomain();
    }

    @Transient
    public CFCloudLocation getLocation() {
        return this.isV2() ? CFCloudLocation.GLOBAL : CFCloudLocation.get(this.myLocationId);
    }

    @Transient
    public boolean isV2() {
        return this.getVersion() == CFVersion.V2;
    }

    @Transient
    public boolean isAppFog() {
        return !this.isV2() && this.getLocation() == CFCloudLocation.GLOBAL && this.getProvider() == CFProvider.APPFOG;
    }

    @Override
    @Transient
    public String getLocationApiUrl() {
        return this.getLocation().getApiUrl(this);
    }

    @Transient
    public String getLocationAppUrl(DeploymentTask<CFDeploymentConfiguration> deploymentTask) {
        return this.getLocation().getAppUrl(this, deploymentTask);
    }
}

