/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.lexer.YAMLFlexLexer;
import org.jetbrains.yaml.parser.YAMLParser;
import org.jetbrains.yaml.psi.impl.YAMLArrayImpl;
import org.jetbrains.yaml.psi.impl.YAMLCompoundValueImpl;
import org.jetbrains.yaml.psi.impl.YAMLDocumentImpl;
import org.jetbrains.yaml.psi.impl.YAMLFileImpl;
import org.jetbrains.yaml.psi.impl.YAMLHashImpl;
import org.jetbrains.yaml.psi.impl.YAMLKeyValueImpl;
import org.jetbrains.yaml.psi.impl.YAMLPlainTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLPsiElementImpl;
import org.jetbrains.yaml.psi.impl.YAMLScalarListImpl;
import org.jetbrains.yaml.psi.impl.YAMLScalarTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLSequenceImpl;

public class YAMLParserDefinition
implements ParserDefinition,
YAMLElementTypes {
    private static final TokenSet myCommentTokens = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        YAMLFlexLexer yAMLFlexLexer = new YAMLFlexLexer();
        if (yAMLFlexLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createLexer"));
        }
        return yAMLFlexLexer;
    }

    @Nullable
    public PsiParser createParser(Project project) {
        return new YAMLParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.WHITESPACE});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = myCommentTokens;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.SCALAR_STRING, YAMLTokenTypes.SCALAR_DSTRING, YAMLTokenTypes.TEXT});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == DOCUMENT) {
            YAMLDocumentImpl yAMLDocumentImpl = new YAMLDocumentImpl(node);
            if (yAMLDocumentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
            }
            return yAMLDocumentImpl;
        }
        if (type == KEY_VALUE_PAIR) {
            YAMLKeyValueImpl yAMLKeyValueImpl = new YAMLKeyValueImpl(node);
            if (yAMLKeyValueImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
            }
            return yAMLKeyValueImpl;
        }
        if (type == COMPOUND_VALUE) {
            YAMLCompoundValueImpl yAMLCompoundValueImpl = new YAMLCompoundValueImpl(node);
            if (yAMLCompoundValueImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
            }
            return yAMLCompoundValueImpl;
        }
        if (type == SEQUENCE) {
            YAMLSequenceImpl yAMLSequenceImpl = new YAMLSequenceImpl(node);
            if (yAMLSequenceImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
            }
            return yAMLSequenceImpl;
        }
        if (type == HASH) {
            YAMLHashImpl yAMLHashImpl = new YAMLHashImpl(node);
            if (yAMLHashImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
            }
            return yAMLHashImpl;
        }
        if (type == ARRAY) {
            YAMLArrayImpl yAMLArrayImpl = new YAMLArrayImpl(node);
            if (yAMLArrayImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
            }
            return yAMLArrayImpl;
        }
        if (type == SCALAR_LIST_VALUE) {
            YAMLScalarListImpl yAMLScalarListImpl = new YAMLScalarListImpl(node);
            if (yAMLScalarListImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
            }
            return yAMLScalarListImpl;
        }
        if (type == SCALAR_TEXT_VALUE) {
            YAMLScalarTextImpl yAMLScalarTextImpl = new YAMLScalarTextImpl(node);
            if (yAMLScalarTextImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
            }
            return yAMLScalarTextImpl;
        }
        if (type == SCALAR_PLAIN_VALUE) {
            YAMLPlainTextImpl yAMLPlainTextImpl = new YAMLPlainTextImpl(node);
            if (yAMLPlainTextImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
            }
            return yAMLPlainTextImpl;
        }
        YAMLPsiElementImpl yAMLPsiElementImpl = new YAMLPsiElementImpl(node);
        if (yAMLPsiElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLParserDefinition", "createElement"));
        }
        return yAMLPsiElementImpl;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new YAMLFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

