/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;

public class YAMLUtil {
    public static boolean isScalarValue(PsiElement element) {
        if (element == null) {
            return false;
        }
        IElementType type = element.getNode().getElementType();
        return YAMLElementTypes.SCALAR_VALUES.contains(type) || type == YAMLTokenTypes.TEXT;
    }

    public static boolean isScalarOrEmptyCompoundValue(PsiElement element) {
        return YAMLUtil.isScalarValue(element) || element instanceof YAMLCompoundValue && ((YAMLCompoundValue)element).getYAMLElements().isEmpty();
    }

    @Nullable
    public static String getFullKey(YAMLKeyValue yamlKeyValue) {
        PsiElement parent;
        StringBuilder builder = new StringBuilder();
        YAMLKeyValue element = yamlKeyValue;
        while (element != null && (parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{YAMLKeyValue.class, YAMLDocument.class})) instanceof YAMLKeyValue) {
            if (builder.length() > 0) {
                builder.insert(0, '.');
            }
            builder.insert(0, element.getKeyText());
            element = (YAMLKeyValue)parent;
        }
        return builder.toString();
    }

    @Nullable
    public static YAMLPsiElement getRecord(YAMLFile file, String ... key) {
        assert (key.length != 0);
        YAMLPsiElement root = file.getDocuments().get(0);
        if (root != null) {
            YAMLPsiElement record = root;
            for (String aKey : key) {
                if ((record = YAMLUtil.findChildByName(record, aKey)) != null) continue;
                return null;
            }
            return record;
        }
        return null;
    }

    @Nullable
    public static YAMLKeyValue findChildByName(YAMLPsiElement element, String name) {
        PsiElement value;
        List<YAMLPsiElement> list = element instanceof YAMLKeyValue ? ((value = ((YAMLKeyValue)element).getValue()) instanceof YAMLCompoundValue ? ((YAMLCompoundValue)value).getYAMLElements() : Collections.emptyList()) : element.getYAMLElements();
        for (YAMLPsiElement child : list) {
            if (!(child instanceof YAMLKeyValue)) continue;
            YAMLKeyValue yamlKeyValue = (YAMLKeyValue)child;
            String text = yamlKeyValue.getKeyText();
            if (name != null && !name.equals(text) && !name.equals(StringUtil.unquoteString((String)text))) continue;
            return yamlKeyValue;
        }
        return null;
    }

    @Nullable
    public static Pair<PsiElement, String> getValue(YAMLFile file, String ... key) {
        PsiElement psiValue;
        YAMLPsiElement record = YAMLUtil.getRecord(file, key);
        if (record instanceof YAMLKeyValue && YAMLUtil.isScalarValue(psiValue = ((YAMLKeyValue)record).getValue())) {
            return Pair.create((Object)psiValue, (Object)((YAMLKeyValue)record).getValueText());
        }
        return null;
    }

    public List<String> getAllKeys(YAMLFile file) {
        return this.getAllKeys(file, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public List<String> getAllKeys(YAMLFile file, String[] key) {
        YAMLPsiElement record = YAMLUtil.getRecord(file, key);
        if (!(record instanceof YAMLKeyValue)) {
            return Collections.emptyList();
        }
        PsiElement psiValue = ((YAMLKeyValue)record).getValue();
        StringBuilder builder = new StringBuilder();
        for (String keyPart : key) {
            if (builder.length() != 0) {
                builder.append(".");
            }
            builder.append(keyPart);
        }
        ArrayList<String> list = new ArrayList<String>();
        YAMLUtil.addKeysRec(builder.toString(), psiValue, list);
        return list;
    }

    private static void addKeysRec(String prefix, PsiElement element, List<String> list) {
        if (element instanceof YAMLCompoundValue) {
            for (YAMLPsiElement child : ((YAMLCompoundValue)element).getYAMLElements()) {
                YAMLUtil.addKeysRec(prefix, (PsiElement)child, list);
            }
        }
        if (element instanceof YAMLKeyValue) {
            YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
            PsiElement psiValue = yamlKeyValue.getValue();
            String key = yamlKeyValue.getKeyText();
            if (prefix.length() > 0) {
                key = prefix + "." + key;
            }
            if (YAMLUtil.isScalarOrEmptyCompoundValue(psiValue)) {
                list.add(key);
            } else {
                YAMLUtil.addKeysRec(key, psiValue, list);
            }
        }
    }

    public YAMLKeyValue createI18nRecord(YAMLFile file, String key, String text) {
        return YAMLUtil.createI18nRecord(file, key.split("\\."), text);
    }

    @Nullable
    public static YAMLKeyValue createI18nRecord(YAMLFile file, String[] key, String text) {
        YAMLPsiElement root = file.getDocuments().get(0);
        if (root != null) {
            int i;
            YAMLPsiElement record = root;
            int keyLength = key.length;
            for (i = 0; i < keyLength; ++i) {
                YAMLKeyValue nextRecord = YAMLUtil.findChildByName(record, key[i]);
                if (i == 0 && nextRecord == null) {
                    YAMLFile yamlFile = (YAMLFile)PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText("temp." + YAMLFileType.YML.getDefaultExtension(), (FileType)YAMLFileType.YML, (CharSequence)(key[i] + ":"), LocalTimeCounter.currentTime(), true);
                    YAMLKeyValue topKeyValue = (YAMLKeyValue)yamlFile.getDocuments().get(0).getYAMLElements().get(0);
                    nextRecord = (YAMLKeyValue)root.add((PsiElement)topKeyValue);
                }
                if (nextRecord != null) {
                    record = nextRecord;
                    continue;
                }
                if (!(record instanceof YAMLKeyValue)) continue;
                YAMLKeyValue keyValue = (YAMLKeyValue)record;
                PsiElement value = keyValue.getValue();
                String indent = keyValue.getValueIndent();
                StringBuilder builder = new StringBuilder();
                builder.append(keyValue.getKeyText() + ":");
                for (int j = i; j < keyLength; ++j) {
                    builder.append("\n").append(indent.length() == 0 ? "  " : indent);
                    builder.append(key[j]).append(":");
                    indent = indent + "  ";
                }
                builder.append(" ").append(text);
                YAMLFile yamlFile = (YAMLFile)PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText("temp." + YAMLFileType.YML.getDefaultExtension(), (FileType)YAMLFileType.YML, (CharSequence)builder.toString(), LocalTimeCounter.currentTime(), true);
                YAMLKeyValue topKeyValue = (YAMLKeyValue)yamlFile.getDocuments().get(0).getYAMLElements().get(0);
                if (value == null) {
                    YAMLKeyValue newKewValue = (YAMLKeyValue)keyValue.replace((PsiElement)topKeyValue);
                    return (YAMLKeyValue)newKewValue.getLastChild();
                }
                ASTNode generatedNode = topKeyValue.getNode();
                ASTNode[] generatedChildren = generatedNode.getChildren(null);
                ASTNode valueNode = value.getNode();
                if (valueNode instanceof LeafElement) {
                    return (YAMLKeyValue)value.replace(generatedChildren[3].getChildren(null)[0].getPsi());
                }
                valueNode.addChild(generatedChildren[1]);
                valueNode.addChild(generatedChildren[2]);
                valueNode.addChild(generatedChildren[3].getChildren(null)[0]);
                return (YAMLKeyValue)value.getLastChild();
            }
            StringBuilder builder = new StringBuilder();
            int top = Math.min(i + 1, keyLength);
            for (int j = 0; j < top; ++j) {
                if (builder.length() > 0) {
                    builder.append('.');
                }
                builder.append(key[j]);
            }
            throw new IncorrectOperationException(YAMLBundle.message("new.name.conflicts.with", builder.toString()));
        }
        return null;
    }

    public static void removeI18nRecord(YAMLFile file, String[] key) {
        YAMLPsiElement element = YAMLUtil.getRecord(file, key);
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof YAMLDocument) {
                ((YAMLKeyValue)element).getValue().delete();
                return;
            }
            if (parent instanceof YAMLCompoundValue && ((YAMLCompoundValue)parent).getYAMLElements().size() > 1) {
                element.delete();
                return;
            }
            element = parent;
        }
    }

    public static PsiElement rename(YAMLKeyValue element, String newName) {
        if (newName.contains(".")) {
            throw new IncorrectOperationException(YAMLBundle.message("rename.wrong.name"));
        }
        if (newName.equals(element.getName())) {
            throw new IncorrectOperationException(YAMLBundle.message("rename.same.name"));
        }
        YAMLFile yamlFile = (YAMLFile)PsiFileFactory.getInstance((Project)element.getProject()).createFileFromText("temp." + YAMLFileType.YML.getDefaultExtension(), (FileType)YAMLFileType.YML, (CharSequence)(newName + ": Foo"), LocalTimeCounter.currentTime(), true);
        YAMLKeyValue topKeyValue = (YAMLKeyValue)yamlFile.getDocuments().get(0).getYAMLElements().get(0);
        element.getKey().replace(topKeyValue.getKey());
        return element;
    }
}

