/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;

public class YAMLFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private static final TokenSet COMPOUND_VALUE = TokenSet.create((IElementType[])new IElementType[]{YAMLElementTypes.COMPOUND_VALUE});

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "buildFoldRegions"));
        }
        LinkedList<FoldingDescriptor> descriptors = new LinkedList<FoldingDescriptor>();
        YAMLFoldingBuilder.collectDescriptors(astNode, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    private static void collectDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "collectDescriptors"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "collectDescriptors"));
        }
        IElementType type = node.getElementType();
        TextRange nodeTextRange = node.getTextRange();
        if (!StringUtil.isEmptyOrSpaces((String)node.getText()) && nodeTextRange.getLength() >= 2) {
            ASTNode[] children;
            if (type == YAMLElementTypes.KEY_VALUE_PAIR && (children = node.getChildren(COMPOUND_VALUE)).length > 0 && !StringUtil.isEmpty((String)children[0].getText().trim())) {
                descriptors.add(new FoldingDescriptor(node, nodeTextRange));
            }
            if (type == YAMLElementTypes.DOCUMENT && node.getTreeParent().getChildren(TokenSet.create((IElementType[])new IElementType[]{YAMLElementTypes.DOCUMENT})).length > 1) {
                descriptors.add(new FoldingDescriptor(node, nodeTextRange));
            }
            if (type == YAMLElementTypes.SCALAR_TEXT_VALUE || type == YAMLElementTypes.SCALAR_LIST_VALUE || type == YAMLElementTypes.SCALAR_PLAIN_VALUE) {
                descriptors.add(new FoldingDescriptor(node, nodeTextRange));
            }
        }
        for (ASTNode child : node.getChildren(null)) {
            YAMLFoldingBuilder.collectDescriptors(child, descriptors);
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
        }
        IElementType type = node.getElementType();
        if (type == YAMLElementTypes.DOCUMENT) {
            return "---";
        }
        if (type == YAMLElementTypes.KEY_VALUE_PAIR) {
            return node.getFirstChildNode().getText();
        }
        if (type == YAMLElementTypes.SCALAR_TEXT_VALUE || type == YAMLElementTypes.SCALAR_LIST_VALUE) {
            return node.getText().substring(0, 1);
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }
}

