/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;

public class YAMLParser
implements PsiParser,
YAMLTokenTypes {
    private PsiBuilder myBuilder;
    private boolean eolSeen = false;
    private int myIndent;
    private PsiBuilder.Marker myAfterLastEolMarker;

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/yaml/parser/YAMLParser", "parse"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/yaml/parser/YAMLParser", "parse"));
        }
        this.myBuilder = builder;
        PsiBuilder.Marker fileMarker = this.mark();
        this.parseFile();
        assert (this.myBuilder.eof()) : "Not all tokens were passed.";
        fileMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parse"));
        }
        return aSTNode;
    }

    private void parseFile() {
        this.passJunk();
        this.parseDocument();
        this.passJunk();
        while (!this.myBuilder.eof()) {
            this.parseDocument();
            this.passJunk();
        }
        this.dropEolMarker();
    }

    private void parseDocument() {
        PsiBuilder.Marker marker = this.mark();
        if (this.myBuilder.getTokenType() == DOCUMENT_MARKER) {
            this.advanceLexer();
        }
        this.parseStatements(0);
        this.dropEolMarker();
        marker.done((IElementType)YAMLElementTypes.DOCUMENT);
    }

    private void parseStatements(int indent) {
        boolean sequencesOnTheSameIndent = this.isSequenceStart(indent);
        while (!(this.eof() || !this.isJunk() && this.eolSeen && this.myIndent <= indent && (this.myIndent != indent || sequencesOnTheSameIndent && !this.isSequenceStart(indent)))) {
            this.parseSingleStatement(indent);
        }
    }

    private boolean isSequenceStart(int indent) {
        return this.myIndent == indent && this.getTokenType() == SEQUENCE_MARKER;
    }

    private void parseSingleStatement(int indent) {
        if (this.eof()) {
            return;
        }
        IElementType tokenType = this.getTokenType();
        if (tokenType == LBRACE) {
            this.parseHash();
        } else if (tokenType == LBRACKET) {
            this.parseArray();
        } else if (tokenType == SEQUENCE_MARKER) {
            this.parseSequence();
        } else if (tokenType == SCALAR_KEY) {
            this.parseScalarKeyValue(indent);
        } else if (YAMLElementTypes.SCALAR_VALUES.contains(this.getTokenType())) {
            this.parseScalarValue(indent);
        } else {
            this.advanceLexer();
        }
    }

    private void parseScalarValue(int indent) {
        IElementType tokenType = this.getTokenType();
        assert (YAMLElementTypes.SCALAR_VALUES.contains(tokenType)) : "Scalar value expected!";
        if (tokenType == SCALAR_LIST || tokenType == SCALAR_TEXT) {
            this.parseMultiLineScalar(tokenType);
        } else if (tokenType == TEXT) {
            this.parseMultiLinePlainScalar(indent);
        } else {
            this.advanceLexer();
        }
    }

    private void parseMultiLineScalar(IElementType tokenType) {
        PsiBuilder.Marker marker = this.mark();
        IElementType type = this.getTokenType();
        while (type == tokenType || type == INDENT || type == EOL) {
            this.advanceLexer();
            type = this.getTokenType();
        }
        this.rollBackToEol();
        marker.done((IElementType)(tokenType == SCALAR_LIST ? YAMLElementTypes.SCALAR_LIST_VALUE : YAMLElementTypes.SCALAR_TEXT_VALUE));
    }

    private void parseMultiLinePlainScalar(int indent) {
        PsiBuilder.Marker marker = this.mark();
        PsiBuilder.Marker lastTextEnd = null;
        boolean isMultiLine = false;
        IElementType type = this.getTokenType();
        while (type == TEXT || type == INDENT || type == EOL) {
            this.advanceLexer();
            if (type == TEXT) {
                if (lastTextEnd != null && this.myIndent <= indent) break;
                if (lastTextEnd != null) {
                    isMultiLine = true;
                    lastTextEnd.drop();
                }
                lastTextEnd = this.mark();
            }
            type = this.getTokenType();
        }
        this.rollBackToEol();
        assert (lastTextEnd != null);
        lastTextEnd.rollbackTo();
        if (isMultiLine) {
            marker.done((IElementType)YAMLElementTypes.SCALAR_PLAIN_VALUE);
        } else {
            marker.drop();
        }
    }

    private void parseScalarKeyValue(int indent) {
        PsiBuilder.Marker marker = this.mark();
        assert (this.getTokenType() == SCALAR_KEY) : "Expected scalar key";
        this.eolSeen = false;
        this.advanceLexer();
        this.passJunk();
        if (YAMLElementTypes.SCALAR_VALUES.contains(this.getTokenType())) {
            this.parseScalarValue(indent);
        } else {
            PsiBuilder.Marker valueMarker = this.mark();
            if (!this.eolSeen) {
                this.parseSingleStatement(this.myIndent);
            } else {
                while (!this.eof() && (this.isJunk() || this.myIndent > indent || this.isSequenceStart(indent))) {
                    this.parseStatements(this.myIndent);
                }
            }
            this.rollBackToEol();
            valueMarker.done((IElementType)YAMLElementTypes.COMPOUND_VALUE);
        }
        marker.done((IElementType)YAMLElementTypes.KEY_VALUE_PAIR);
    }

    private void parseSequence() {
        int indent = this.myIndent + 2;
        PsiBuilder.Marker sequenceMarker = this.mark();
        this.advanceLexer();
        this.eolSeen = false;
        this.passJunk();
        this.parseStatements(indent);
        this.rollBackToEol();
        sequenceMarker.done((IElementType)YAMLElementTypes.SEQUENCE);
    }

    private void parseHash() {
        PsiBuilder.Marker marker = this.mark();
        this.advanceLexer();
        while (!this.eof()) {
            if (this.getTokenType() == RBRACE) {
                this.advanceLexer();
                break;
            }
            this.parseSingleStatement(0);
        }
        this.dropEolMarker();
        marker.done((IElementType)YAMLElementTypes.HASH);
    }

    private void parseArray() {
        PsiBuilder.Marker marker = this.mark();
        this.advanceLexer();
        while (!this.eof()) {
            if (this.getTokenType() == RBRACKET) {
                this.advanceLexer();
                break;
            }
            this.parseSingleStatement(0);
        }
        this.dropEolMarker();
        marker.done((IElementType)YAMLElementTypes.ARRAY);
    }

    private boolean eof() {
        return this.myBuilder.eof() || this.myBuilder.getTokenType() == DOCUMENT_MARKER;
    }

    @Nullable
    private IElementType getTokenType() {
        return this.eof() ? null : this.myBuilder.getTokenType();
    }

    private void dropEolMarker() {
        if (this.myAfterLastEolMarker != null) {
            this.myAfterLastEolMarker.drop();
            this.myAfterLastEolMarker = null;
        }
    }

    private void rollBackToEol() {
        if (this.eolSeen && this.myAfterLastEolMarker != null) {
            this.eolSeen = false;
            this.myAfterLastEolMarker.rollbackTo();
            this.myAfterLastEolMarker = null;
        }
    }

    private PsiBuilder.Marker mark() {
        this.dropEolMarker();
        return this.myBuilder.mark();
    }

    private void advanceLexer() {
        if (this.myBuilder.eof()) {
            return;
        }
        IElementType type = this.myBuilder.getTokenType();
        boolean bl = this.eolSeen = this.eolSeen || type == EOL;
        if (type == EOL) {
            this.myAfterLastEolMarker = this.mark();
            this.myIndent = 0;
        } else if (type == INDENT) {
            this.myIndent = this.getCurrentTokenLength();
        } else {
            this.dropEolMarker();
        }
        this.myBuilder.advanceLexer();
    }

    private int getCurrentTokenLength() {
        return this.myBuilder.rawTokenTypeStart(1) - this.myBuilder.getCurrentOffset();
    }

    private void passJunk() {
        while (!this.eof() && this.isJunk()) {
            this.advanceLexer();
        }
    }

    private boolean isJunk() {
        IElementType type = this.getTokenType();
        return type == INDENT || type == EOL;
    }
}

