/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.impl.YAMLPsiElementImpl;

public class YAMLKeyValueImpl
extends YAMLPsiElementImpl
implements YAMLKeyValue {
    public YAMLKeyValueImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/psi/impl/YAMLKeyValueImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public String toString() {
        return "YAML key value";
    }

    @Override
    public PsiElement getKey() {
        return this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.SCALAR_KEY}))[0].getPsi();
    }

    public String getName() {
        return this.getKeyText();
    }

    @Override
    public String getKeyText() {
        String text = this.getKey().getText();
        return text.substring(0, text.length() - 1);
    }

    @Override
    public PsiElement getValue() {
        PsiElement element;
        for (element = this.getKey().getNextSibling(); element != null && !(element instanceof YAMLCompoundValue) && !YAMLElementTypes.SCALAR_VALUES.contains(element.getNode().getElementType()); element = element.getNextSibling()) {
        }
        return element;
    }

    @Override
    public String getValueText() {
        PsiElement value = this.getValue();
        if (value == null) {
            return "";
        }
        String text = value.getText();
        if (text.startsWith("'") || text.startsWith("\"")) {
            text = text.substring(1);
        }
        if (text.endsWith("'") || text.endsWith("\"")) {
            text = text.substring(0, text.length() - 1);
        }
        if (text.startsWith("|") && (text = text.substring(1).replaceAll("\n[ \t]+", "; ")).length() >= 2) {
            text = text.substring(2);
        }
        return text;
    }

    @Override
    public void setValueText(String text) {
        YAMLFile yamlFile = (YAMLFile)PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("temp." + YAMLFileType.YML.getDefaultExtension(), (FileType)YAMLFileType.YML, (CharSequence)("foo: " + text), LocalTimeCounter.currentTime(), true);
        YAMLKeyValue topKeyValue = (YAMLKeyValue)yamlFile.getDocuments().get(0).getYAMLElements().get(0);
        this.getValue().replace(topKeyValue.getValue());
    }

    public ItemPresentation getPresentation() {
        final YAMLFile yamlFile = (YAMLFile)this.getContainingFile();
        final PsiElement value = this.getValue();
        return new ItemPresentation(){

            public String getPresentableText() {
                if (YAMLUtil.isScalarValue(value)) {
                    return YAMLKeyValueImpl.this.getValueText();
                }
                return YAMLKeyValueImpl.this.getName();
            }

            public String getLocationString() {
                return "[" + yamlFile.getName() + "]";
            }

            public Icon getIcon(boolean open) {
                return PlatformIcons.PROPERTY_ICON;
            }
        };
    }

    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/yaml/psi/impl/YAMLKeyValueImpl", "setName"));
        }
        return YAMLUtil.rename(this, newName);
    }

    @Override
    public String getValueIndent() {
        ASTNode node;
        IElementType type;
        PsiElement value = this.getValue();
        if (value != null && ((type = (node = value.getNode().getTreePrev()).getElementType()) == YAMLTokenTypes.WHITESPACE || type == YAMLTokenTypes.INDENT)) {
            return node.getText();
        }
        return "";
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, YAMLKeyValue.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLKeyValueImpl", "getReferences"));
        }
        return psiReferenceArray;
    }
}

