/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;

public class YAMLStructureViewElement
implements StructureViewTreeElement {
    private final YAMLPsiElement myElement;

    public YAMLStructureViewElement(YAMLPsiElement element) {
        this.myElement = element;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        if (this.myElement instanceof YAMLFile || this.myElement instanceof YAMLDocument || this.myElement instanceof YAMLKeyValue && ((YAMLKeyValue)this.myElement).getValue() instanceof YAMLCompoundValue) {
            List<YAMLPsiElement> children = this.myElement instanceof YAMLKeyValue ? ((YAMLCompoundValue)((YAMLKeyValue)this.myElement).getValue()).getYAMLElements() : this.myElement.getYAMLElements();
            ArrayList<YAMLStructureViewElement> structureElements = new ArrayList<YAMLStructureViewElement>();
            for (YAMLPsiElement child : children) {
                if (!(child instanceof YAMLDocument) && !(child instanceof YAMLKeyValue)) continue;
                structureElements.add(new YAMLStructureViewElement(child));
            }
            StructureViewTreeElement[] structureViewTreeElementArray = structureElements.toArray(new StructureViewTreeElement[structureElements.size()]);
            if (structureViewTreeElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getChildren"));
            }
            return structureViewTreeElementArray;
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getChildren"));
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        if (this.myElement instanceof YAMLKeyValue) {
            final YAMLKeyValue kv = (YAMLKeyValue)this.myElement;
            ItemPresentation itemPresentation = new ItemPresentation(){

                public String getPresentableText() {
                    return kv.getKeyText();
                }

                public String getLocationString() {
                    return null;
                }

                public Icon getIcon(boolean open) {
                    PsiElement value = kv.getValue();
                    return value instanceof YAMLCompoundValue && !((YAMLCompoundValue)value).getYAMLElements().isEmpty() ? PlatformIcons.XML_TAG_ICON : PlatformIcons.PROPERTY_ICON;
                }
            };
            if (itemPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getPresentation"));
            }
            return itemPresentation;
        }
        if (this.myElement instanceof YAMLDocument) {
            ItemPresentation itemPresentation = new ItemPresentation(){

                public String getPresentableText() {
                    return "YAML document";
                }

                public String getLocationString() {
                    return null;
                }

                public Icon getIcon(boolean open) {
                    return PlatformIcons.XML_TAG_ICON;
                }
            };
            if (itemPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getPresentation"));
            }
            return itemPresentation;
        }
        ItemPresentation itemPresentation = this.myElement.getPresentation();
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getPresentation"));
        }
        return itemPresentation;
    }

    public YAMLPsiElement getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.canNavigateToSource();
    }
}

