/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageImpl
extends PsiPackageBase
implements Queryable,
PsiPackage {
    private static final Logger LOG = Logger.getInstance(PsiPackageImpl.class);
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectoriesWithLibSources;
    private volatile SoftReference<Map<String, PsiClass[]>> myClassCache;
    private volatile SoftReference<Map<GlobalSearchScope, Map<String, PsiClass[]>>> myDumbModeFullCache;
    private volatile SoftReference<Map<Pair<GlobalSearchScope, String>, PsiClass[]>> myDumbModePartialCache;

    public PsiPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    @Override
    protected Collection<PsiDirectory> getAllDirectories(boolean includeLibrarySources) {
        if (includeLibrarySources) {
            if (this.myDirectoriesWithLibSources == null) {
                this.myDirectoriesWithLibSources = this.createCachedDirectories(true);
            }
            return this.myDirectoriesWithLibSources.getValue();
        }
        if (this.myDirectories == null) {
            this.myDirectories = this.createCachedDirectories(false);
        }
        return this.myDirectories.getValue();
    }

    @NotNull
    private CachedValue<Collection<PsiDirectory>> createCachedDirectories(final boolean includeLibrarySources) {
        CachedValue<Collection<PsiDirectory>> cachedValue2 = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new CachedValueProvider<Collection<PsiDirectory>>(){

            @Override
            public CachedValueProvider.Result<Collection<PsiDirectory>> compute() {
                CommonProcessors.CollectProcessor<PsiDirectory> processor = new CommonProcessors.CollectProcessor<PsiDirectory>();
                PsiPackageImpl.this.getFacade().processPackageDirectories(PsiPackageImpl.this, PsiPackageImpl.this.allScope(), processor, includeLibrarySources);
                return CachedValueProvider.Result.create(processor.getResults(), PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(PsiPackageImpl.this));
            }
        }, false);
        if (cachedValue2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "createCachedDirectories"));
        }
        return cachedValue2;
    }

    @Override
    protected PsiElement findPackage(String qName) {
        return this.getFacade().findPackage(qName);
    }

    @Override
    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newQualifiedName", "com/intellij/psi/impl/file/PsiPackageImpl", "handleQualifiedNameChange"));
        }
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    @Override
    public VirtualFile[] occursInPackagePrefixes() {
        return PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
    }

    @Override
    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @Override
    protected PsiPackageImpl createInstance(PsiManager manager, String qName) {
        return new PsiPackageImpl(this.myManager, qName);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    @Override
    public boolean isValid() {
        return PsiPackageImplementationHelper.getInstance().packagePrefixExists(this) || !this.getAllDirectories(true).isEmpty();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/file/PsiPackageImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPackage(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(this.allScope());
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    protected GlobalSearchScope allScope() {
        GlobalSearchScope globalSearchScope = PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope(this.getProject()));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "allScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope2);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiFile[] getFiles(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/PsiPackageImpl", "getFiles"));
        }
        return this.getFacade().getPackageFiles(this, scope2);
    }

    @Override
    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new PackageAnnotationValueProvider());
        }
        return this.myAnnotationList.getValue();
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(this.allScope());
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope2);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(this.myManager.getProject());
    }

    @NotNull
    private PsiClass[] getCachedClassesByName(@NotNull String name, GlobalSearchScope scope2) {
        PsiClass[] classes2;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
        }
        if (DumbService.getInstance(this.getProject()).isDumb()) {
            PsiClass[] psiClassArray = this.getCachedClassInDumbMode(name, scope2);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
            }
            return psiClassArray;
        }
        Map<String, PsiClass[]> map2 = SoftReference.dereference(this.myClassCache);
        if (map2 == null) {
            map2 = ContainerUtil.createConcurrentSoftValueMap();
            this.myClassCache = new SoftReference<ConcurrentMap<String, PsiClass[]>>((ConcurrentMap<String, PsiClass[]>)map2);
        }
        if ((classes2 = map2.get(name)) != null) {
            if (classes2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
            }
            return classes2;
        }
        String qName = this.getQualifiedName();
        String classQName = !qName.isEmpty() ? qName + "." + name : name;
        classes2 = this.getFacade().findClasses(classQName, new EverythingGlobalScope(this.getProject()));
        map2.put(name, classes2);
        if (classes2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
        }
        return classes2;
    }

    private PsiClass[] getCachedClassInDumbMode(String name, GlobalSearchScope scope2) {
        PsiClass[] classes2;
        Map<String, PsiClass[]> map2;
        Map<GlobalSearchScope, Map<String, PsiClass[]>> scopeMap = SoftReference.dereference(this.myDumbModeFullCache);
        if (scopeMap == null) {
            scopeMap = ContainerUtil.newConcurrentMap();
            this.myDumbModeFullCache = new SoftReference<ConcurrentMap<GlobalSearchScope, Map<String, PsiClass[]>>>((ConcurrentMap<GlobalSearchScope, Map<String, PsiClass[]>>)scopeMap);
        }
        if ((map2 = scopeMap.get(scope2)) == null) {
            PsiClass[] array = this.findClassesHeuristically(name, scope2);
            if (array != null) {
                return array;
            }
            map2 = new HashMap<String, PsiClass[]>();
            for (PsiClass psiClass : this.getClasses(scope2)) {
                PsiClass[] psiClassArray;
                String psiClassName = psiClass.getName();
                if (psiClassName == null) continue;
                PsiClass[] existing = map2.get(psiClassName);
                if (existing == null) {
                    PsiClass[] psiClassArray2 = new PsiClass[1];
                    psiClassArray = psiClassArray2;
                    psiClassArray2[0] = psiClass;
                } else {
                    psiClassArray = ArrayUtil.append(existing, psiClass);
                }
                map2.put(psiClassName, psiClassArray);
            }
            scopeMap.put(scope2, map2);
        }
        return (classes2 = map2.get(name)) == null ? PsiClass.EMPTY_ARRAY : classes2;
    }

    @Nullable
    private PsiClass[] findClassesHeuristically(final String name, GlobalSearchScope scope2) {
        PsiClass[] result2;
        if (this.findSubPackageByName(name) != null) {
            return PsiClass.EMPTY_ARRAY;
        }
        Map<Pair<GlobalSearchScope, String>, PsiClass[]> partial = SoftReference.dereference(this.myDumbModePartialCache);
        if (partial == null) {
            partial = ContainerUtil.newConcurrentMap();
            this.myDumbModePartialCache = new SoftReference<ConcurrentMap<Pair<GlobalSearchScope, String>, PsiClass[]>>((ConcurrentMap<Pair<GlobalSearchScope, String>, PsiClass[]>)partial);
        }
        if ((result2 = partial.get(Pair.create(scope2, name))) == null) {
            ArrayList<PsiClass> fastClasses = ContainerUtil.newArrayList();
            for (PsiDirectory directory : this.getDirectories(scope2)) {
                List<PsiFile> sameNamed = ContainerUtil.filter(directory.getFiles(), new Condition<PsiFile>(){

                    @Override
                    public boolean value(PsiFile file) {
                        return file.getName().contains(name);
                    }
                });
                Collections.addAll(fastClasses, CoreJavaDirectoryService.getPsiClasses(directory, sameNamed.toArray(new PsiFile[sameNamed.size()])));
            }
            if (!fastClasses.isEmpty()) {
                result2 = fastClasses.toArray(new PsiClass[fastClasses.size()]);
                partial.put(Pair.create(scope2, name), result2);
            }
        }
        return result2;
    }

    @Override
    public boolean containsClassNamed(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "containsClassNamed"));
        }
        return this.getCachedClassesByName(name, new EverythingGlobalScope(this.getProject())).length > 0;
    }

    @Override
    @NotNull
    public PsiClass[] findClassByShortName(@NotNull String name, final @NotNull GlobalSearchScope scope2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        PsiClass[] allClasses = this.getCachedClassesByName(name, scope2);
        if (allClasses.length == 0) {
            if (allClasses == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
            }
            return allClasses;
        }
        if (allClasses.length == 1) {
            PsiClass[] psiClassArray = PsiSearchScopeUtil.isInScope(scope2, (PsiElement)allClasses[0]) ? allClasses : PsiClass.EMPTY_ARRAY;
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
            }
            return psiClassArray;
        }
        PsiClass[] array = ContainerUtil.findAllAsArray(allClasses, new Condition<PsiClass>(){

            @Override
            public boolean value(PsiClass aClass2) {
                return PsiSearchScopeUtil.isInScope(scope2, (PsiElement)aClass2);
            }
        });
        Arrays.sort(array, new Comparator<PsiClass>(){

            @Override
            public int compare(PsiClass o1, PsiClass o2) {
                VirtualFile file1 = o1.getContainingFile().getVirtualFile();
                VirtualFile file2 = o2.getContainingFile().getVirtualFile();
                if (file1 == null) {
                    return file2 == null ? 0 : -1;
                }
                if (file2 == null) {
                    return 1;
                }
                return scope2.compare(file2, file1);
            }
        });
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        return array;
    }

    @Nullable
    private PsiPackage findSubPackageByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "findSubPackageByName"));
        }
        String qName = this.getQualifiedName();
        String subpackageQName = qName.isEmpty() ? name : qName + "." + name;
        return this.getFacade().findPackage(subpackageQName);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass[] classes2;
        String providedName;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        GlobalSearchScope scope2 = place.getResolveScope();
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        Condition<String> nameCondition = processor.getHint(JavaCompletionHints.NAME_FILTER);
        NameHint providedNameHint = processor.getHint(NameHint.KEY);
        String string = providedName = providedNameHint == null ? null : providedNameHint.getName(state2);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && (providedName != null ? !PsiPackageImpl.processClasses(processor, state2, classes2 = this.findClassByShortName(providedName, scope2), Conditions.<String>alwaysTrue()) : !PsiPackageImpl.processClasses(processor, state2, classes2 = this.getClasses(scope2), nameCondition != null ? nameCondition : Conditions.alwaysTrue()))) {
            return false;
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            if (providedName != null) {
                PsiPackage aPackage = this.findSubPackageByName(providedName);
                if (aPackage != null && !processor.execute(aPackage, state2)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope2)) {
                    String packageName = pack.getName();
                    if (packageName == null || !PsiNameHelper.getInstance(this.myManager.getProject()).isIdentifier(packageName, PsiUtil.getLanguageLevel(this)) || processor.execute(pack, state2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processClasses(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiClass[] classes2, @NotNull Condition<String> nameCondition) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        if (nameCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameCondition", "com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        for (PsiClass aClass2 : classes2) {
            String name = aClass2.getName();
            if (name == null || !nameCondition.value(name)) continue;
            try {
                if (processor.execute(aClass2, state2)) continue;
                return false;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return true;
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    @Override
    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "hasModifierProperty"));
        }
        return false;
    }

    @Override
    public PsiQualifiedNamedElement getContainer() {
        return this.getParentPackage();
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private PackageAnnotationValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList<PsiModifierList> modifiers = ContainerUtil.newArrayList();
            for (PsiDirectory psiDirectory : PsiPackageImpl.this.getDirectories()) {
                PsiFile file = psiDirectory.findFile("package-info.java");
                PsiPackageStatement stmt = file == null ? null : PsiTreeUtil.getChildOfType(file, PsiPackageStatement.class);
                PsiModifierList modifierList = stmt == null ? null : stmt.getAnnotationList();
                ContainerUtil.addIfNotNull(modifiers, modifierList);
            }
            for (NavigatablePsiElement navigatablePsiElement : PsiPackageImpl.this.getFacade().findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", PsiPackageImpl.this.allScope())) {
                ContainerUtil.addIfNotNull(modifiers, navigatablePsiElement.getModifierList());
            }
            PsiCompositeModifierList result2 = modifiers.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), modifiers);
            return new CachedValueProvider.Result<PsiModifierList>(result2, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }
    }
}

